/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.cas;

import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.storage.tapelibrary.TapeLibraryConfiguration;
import fr.gouv.vitam.storage.offers.tape.cas.ArchiveReferentialRepository;
import fr.gouv.vitam.storage.offers.tape.cas.BasicFileStorage;
import fr.gouv.vitam.storage.offers.tape.cas.BucketTopologyHelper;
import fr.gouv.vitam.storage.offers.tape.cas.FileBucketTarCreator;
import fr.gouv.vitam.storage.offers.tape.cas.FileBucketTarCreatorBootstrapRecovery;
import fr.gouv.vitam.storage.offers.tape.cas.InputFileToProcessMessage;
import fr.gouv.vitam.storage.offers.tape.cas.ObjectReferentialRepository;
import fr.gouv.vitam.storage.offers.tape.cas.WriteOrderCreator;
import fr.gouv.vitam.storage.offers.tape.utils.LocalFileUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class FileBucketTarCreatorManager {
    private final BucketTopologyHelper bucketTopologyHelper;
    private final Map<String, FileBucketTarCreator> fileBucketTarCreatorMap;
    private final FileBucketTarCreatorBootstrapRecovery fileBucketTarCreatorBootstrapRecovery;
    private final String inputTarStorageFolder;

    public FileBucketTarCreatorManager(TapeLibraryConfiguration tapeLibraryConfiguration, BasicFileStorage basicFileStorage, BucketTopologyHelper bucketTopologyHelper, ObjectReferentialRepository objectReferentialRepository, ArchiveReferentialRepository archiveReferentialRepository, WriteOrderCreator writeOrderCreator) {
        this.bucketTopologyHelper = bucketTopologyHelper;
        this.fileBucketTarCreatorMap = bucketTopologyHelper.listFileBuckets().stream().collect(Collectors.toMap(fileBucket -> fileBucket, fileBucket -> new FileBucketTarCreator(basicFileStorage, objectReferentialRepository, archiveReferentialRepository, writeOrderCreator, bucketTopologyHelper.getBucketFromFileBucket((String)fileBucket), (String)fileBucket, this.bucketTopologyHelper.getTarBufferingTimeoutInMinutes(this.bucketTopologyHelper.getBucketFromFileBucket((String)fileBucket)), TimeUnit.MINUTES, tapeLibraryConfiguration.getInputTarStorageFolder(), tapeLibraryConfiguration.getMaxTarEntrySize(), tapeLibraryConfiguration.getMaxTarFileSize())));
        this.inputTarStorageFolder = tapeLibraryConfiguration.getInputTarStorageFolder();
        this.fileBucketTarCreatorBootstrapRecovery = new FileBucketTarCreatorBootstrapRecovery(basicFileStorage, objectReferentialRepository);
    }

    public void initializeOnBootstrap() {
        this.ensureWorkingDirectoryExists("backup-db");
        for (Map.Entry<String, FileBucketTarCreator> entry : this.fileBucketTarCreatorMap.entrySet()) {
            String fileBucketId = entry.getKey();
            FileBucketTarCreator fileBucketTarCreator = entry.getValue();
            this.ensureWorkingDirectoryExists(fileBucketId);
            this.fileBucketTarCreatorBootstrapRecovery.initializeOnBootstrap(fileBucketId, fileBucketTarCreator, this.bucketTopologyHelper);
        }
    }

    private void ensureWorkingDirectoryExists(String fileBucketId) {
        Path fileBucketStoragePath = LocalFileUtils.fileBuckedInputFilePath(this.inputTarStorageFolder, fileBucketId);
        try {
            Files.createDirectories(fileBucketStoragePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new VitamRuntimeException("Could not initialize file bucket tar creator service " + fileBucketStoragePath, (Throwable)e);
        }
    }

    public void startListeners() {
        for (FileBucketTarCreator fileBucketTarCreator : this.fileBucketTarCreatorMap.values()) {
            fileBucketTarCreator.startListener();
        }
    }

    public void addToQueue(InputFileToProcessMessage inputFileToProcessMessage) {
        String containerName = inputFileToProcessMessage.getContainerName();
        String fileBucket = this.bucketTopologyHelper.getFileBucketFromContainerName(containerName);
        FileBucketTarCreator fileBucketTarCreator = this.fileBucketTarCreatorMap.get(fileBucket);
        fileBucketTarCreator.addToQueue(inputFileToProcessMessage);
    }

    public boolean containsTar(String fileBucketId, String tarId) {
        FileBucketTarCreator fileBucketTarCreator = this.fileBucketTarCreatorMap.get(fileBucketId);
        return fileBucketTarCreator.containsTar(tarId);
    }

    public Optional<FileInputStream> tryReadTar(String fileBucketId, String tarId) {
        FileBucketTarCreator fileBucketTarCreator = this.fileBucketTarCreatorMap.get(fileBucketId);
        return fileBucketTarCreator.tryReadTar(tarId);
    }
}

