/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.cas;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.storage.engine.common.model.TapeLibraryInputFileObjectStorageLocation;
import fr.gouv.vitam.storage.engine.common.model.TapeObjectReferentialEntity;
import fr.gouv.vitam.storage.offers.tape.cas.BasicFileStorage;
import fr.gouv.vitam.storage.offers.tape.cas.BucketTopologyHelper;
import fr.gouv.vitam.storage.offers.tape.cas.FileBucketTarCreator;
import fr.gouv.vitam.storage.offers.tape.cas.InputFileToProcessMessage;
import fr.gouv.vitam.storage.offers.tape.cas.ObjectReferentialRepository;
import fr.gouv.vitam.storage.offers.tape.exception.ObjectReferentialException;
import fr.gouv.vitam.storage.offers.tape.utils.LocalFileUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileBucketTarCreatorBootstrapRecovery {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(FileBucketTarCreatorBootstrapRecovery.class);
    private final BasicFileStorage basicFileStorage;
    private final ObjectReferentialRepository objectReferentialRepository;

    public FileBucketTarCreatorBootstrapRecovery(BasicFileStorage basicFileStorage, ObjectReferentialRepository objectReferentialRepository) {
        this.basicFileStorage = basicFileStorage;
        this.objectReferentialRepository = objectReferentialRepository;
    }

    public void initializeOnBootstrap(String fileBucketId, FileBucketTarCreator fileBucketTarCreator, BucketTopologyHelper bucketTopologyHelper) {
        Set<String> containerNames = bucketTopologyHelper.listContainerNames(fileBucketId);
        try {
            for (String containerName : containerNames) {
                Stream<String> storageIdsStream = this.basicFileStorage.listStorageIdsByContainerName(containerName);
                try {
                    UnmodifiableIterator bulkIterator = Iterators.partition(storageIdsStream.iterator(), (int)VitamConfiguration.getBatchSize());
                    while (bulkIterator.hasNext()) {
                        List storageIds = (List)bulkIterator.next();
                        try {
                            this.recoverBulkStorageIds(containerName, storageIds, fileBucketTarCreator);
                        }
                        catch (ObjectReferentialException e) {
                            throw new VitamRuntimeException("Could not initialize service to container " + containerName + " files " + storageIds, (Throwable)e);
                        }
                    }
                }
                finally {
                    if (storageIdsStream == null) continue;
                    storageIdsStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new VitamRuntimeException("Could not recover file bucket tar creator on bootstrap for fileBucket " + fileBucketId, (Throwable)e);
        }
    }

    private void recoverBulkStorageIds(String containerName, List<String> storageIds, FileBucketTarCreator fileBucketTarCreator) throws ObjectReferentialException {
        if (storageIds.isEmpty()) {
            return;
        }
        Map<String, String> storageIdToObjectNameMap = storageIds.stream().collect(Collectors.toMap(storageId -> storageId, LocalFileUtils::storageIdToObjectName));
        HashSet<String> objectNames = new HashSet<String>(storageIdToObjectNameMap.values());
        List<TapeObjectReferentialEntity> objectReferentialEntities = this.objectReferentialRepository.bulkFind(containerName, objectNames);
        Map<String, TapeObjectReferentialEntity> objectReferentialEntityByObjectNameMap = objectReferentialEntities.stream().collect(Collectors.toMap(entity -> entity.getId().getObjectName(), entity -> entity));
        for (String storageId2 : storageIds) {
            String objectName = storageIdToObjectNameMap.get(storageId2);
            if (!objectReferentialEntityByObjectNameMap.containsKey(objectName)) {
                LOGGER.warn("Incomplete file " + storageId2 + ". Will be deleted");
                this.basicFileStorage.deleteFile(containerName, storageId2);
                continue;
            }
            TapeObjectReferentialEntity objectReferentialEntity = objectReferentialEntityByObjectNameMap.get(objectName);
            if (!storageId2.equals(objectReferentialEntity.getStorageId())) {
                LOGGER.warn("Incomplete or obsolete file " + storageId2 + ". Will be deleted");
                this.basicFileStorage.deleteFile(containerName, storageId2);
                continue;
            }
            if (objectReferentialEntity.getLocation() instanceof TapeLibraryInputFileObjectStorageLocation) {
                LOGGER.warn("Input file to be scheduled for archival " + containerName + "/" + storageId2);
                fileBucketTarCreator.addToQueue(new InputFileToProcessMessage(containerName, objectName, storageId2, objectReferentialEntity.getSize(), objectReferentialEntity.getDigest(), objectReferentialEntity.getDigestType()));
                continue;
            }
            LOGGER.debug("Input file already archived " + containerName + "/" + storageId2);
            this.basicFileStorage.deleteFile(containerName, storageId2);
        }
    }
}

