/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.cas;

import fr.gouv.vitam.common.stream.ExactSizeInputStream;
import fr.gouv.vitam.common.stream.ExtendedFileOutputStream;
import fr.gouv.vitam.storage.offers.tape.utils.LocalFileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class BasicFileStorage {
    private final Path basePath;
    private final Set<String> containerCache = ConcurrentHashMap.newKeySet();

    public BasicFileStorage(String basePath) {
        this.basePath = Paths.get(basePath, new String[0]);
    }

    public String writeFile(String containerName, String objectName, InputStream inputStream, long size) throws IOException {
        this.ensureContainerExists(containerName);
        String storageId = LocalFileUtils.createStorageId(objectName);
        Path filePath = this.getFilePath(containerName, storageId);
        try {
            String string;
            ExtendedFileOutputStream outputStream = new ExtendedFileOutputStream(filePath, true);
            try {
                ExactSizeInputStream exactSizeInputStream = new ExactSizeInputStream(inputStream, size);
                IOUtils.copy((InputStream)exactSizeInputStream, (OutputStream)outputStream);
                string = storageId;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    this.deleteFile(containerName, storageId);
                    throw ex;
                }
            }
            outputStream.close();
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public InputStream readFile(String containerName, String storageId) throws IOException {
        Path filePath = this.getFilePath(containerName, storageId);
        return Files.newInputStream(filePath, StandardOpenOption.READ);
    }

    public void deleteFile(String containerName, String storageId) {
        Path filePath = this.getFilePath(containerName, storageId);
        FileUtils.deleteQuietly((File)filePath.toFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureContainerExists(String containerName) throws IOException {
        if (!this.containerCache.contains(containerName)) {
            Set<String> set = this.containerCache;
            synchronized (set) {
                if (!this.containerCache.contains(containerName)) {
                    Files.createDirectories(this.getContainerPath(this.basePath, containerName), new FileAttribute[0]);
                }
            }
        }
    }

    public Stream<String> listStorageIdsByContainerName(String containerName) throws IOException {
        Path containerPath = this.getContainerPath(this.basePath, containerName);
        if (!Files.exists(containerPath, new LinkOption[0])) {
            return Stream.empty();
        }
        return Files.list(containerPath).map(path -> path.toFile().getName());
    }

    private Path getFilePath(String containerName, String storageId) {
        return this.getContainerPath(this.basePath, containerName).resolve(storageId);
    }

    private Path getContainerPath(Path basePath, String containerName) {
        return basePath.resolve(containerName);
    }
}

