/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.cas;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.stream.ExtendedFileOutputStream;
import fr.gouv.vitam.common.stream.SizedInputStream;
import fr.gouv.vitam.storage.engine.common.model.EntryType;
import fr.gouv.vitam.storage.engine.common.model.QueueMessageType;
import fr.gouv.vitam.storage.engine.common.model.TapeArchiveReferentialEntity;
import fr.gouv.vitam.storage.engine.common.model.TapeLibraryArchiveStorageLocation;
import fr.gouv.vitam.storage.engine.common.model.TapeLibraryBuildingOnDiskArchiveStorageLocation;
import fr.gouv.vitam.storage.engine.common.model.WriteOrder;
import fr.gouv.vitam.storage.offers.tape.cas.ArchiveReferentialRepository;
import fr.gouv.vitam.storage.offers.tape.cas.WriteOrderCreator;
import fr.gouv.vitam.storage.offers.tape.exception.ArchiveReferentialException;
import fr.gouv.vitam.storage.offers.tape.exception.BackupWriteException;
import fr.gouv.vitam.storage.offers.tape.utils.LocalFileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;

public class BackupFileStorage {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(BackupFileStorage.class);
    private final ArchiveReferentialRepository archiveReferentialRepository;
    private final WriteOrderCreator writeOrderCreator;
    private final String bucketId;
    private final String fileBucketId;
    private final Path fileBucketStoragePath;

    public BackupFileStorage(ArchiveReferentialRepository archiveReferentialRepository, WriteOrderCreator writeOrderCreator, String bucketId, String fileBucketId, String inputArchiveStorageFolder) {
        this.archiveReferentialRepository = archiveReferentialRepository;
        this.writeOrderCreator = writeOrderCreator;
        this.bucketId = bucketId;
        this.fileBucketId = fileBucketId;
        this.fileBucketStoragePath = LocalFileUtils.fileBuckedInputFilePath(inputArchiveStorageFolder, fileBucketId);
        try {
            Files.createDirectories(this.fileBucketStoragePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new VitamRuntimeException("Could not initialize file bucket tar creator service " + this.fileBucketStoragePath, (Throwable)e);
        }
    }

    public void writeFile(String uniqueFileName, InputStream in) throws BackupWriteException {
        LOGGER.debug("Write backup file :" + uniqueFileName);
        Digest digest = new Digest(VitamConfiguration.getDefaultDigestType());
        try (ExtendedFileOutputStream extendedFileOutputStream = this.createBackupFile(uniqueFileName);
             SizedInputStream sizedInputStream = new SizedInputStream(in);
             InputStream digestInputStream = digest.getDigestInputStream((InputStream)sizedInputStream);){
            IOUtils.copy((InputStream)digestInputStream, (OutputStream)extendedFileOutputStream);
            extendedFileOutputStream.fsync();
            this.finalizeBackupFile(uniqueFileName, sizedInputStream.getSize(), digest.digestHex());
        }
        catch (IOException | RuntimeException ex) {
            throw new BackupWriteException("An error occurred while copying backup file to disk", ex);
        }
    }

    private ExtendedFileOutputStream createBackupFile(String uniqueFileName) throws BackupWriteException, IOException {
        Path currentArchiveFilePath = this.fileBucketStoragePath.resolve(uniqueFileName);
        Path currentTmpArchiveFilePath = this.fileBucketStoragePath.resolve(uniqueFileName + ".tmp");
        if (currentArchiveFilePath.toFile().exists() || currentTmpArchiveFilePath.toFile().exists()) {
            throw new IOException("Backup file with same name " + uniqueFileName + " already exists or in progress");
        }
        LOGGER.info("Creating file {}", (Object)currentTmpArchiveFilePath);
        try {
            TapeArchiveReferentialEntity tarReferentialEntity = new TapeArchiveReferentialEntity(uniqueFileName, (TapeLibraryArchiveStorageLocation)new TapeLibraryBuildingOnDiskArchiveStorageLocation(), EntryType.BACKUP, null, null, LocalDateUtil.nowFormatted());
            this.archiveReferentialRepository.insert(tarReferentialEntity);
        }
        catch (ArchiveReferentialException ex) {
            throw new BackupWriteException("Could not create a new archive file in DB", ex);
        }
        return new ExtendedFileOutputStream(currentTmpArchiveFilePath, true);
    }

    private void finalizeBackupFile(String uniqueFileName, long size, String digest) throws IOException {
        Path currentArchiveFilePath = this.fileBucketStoragePath.resolve(uniqueFileName);
        Path currentTmpArchiveFilePath = this.fileBucketStoragePath.resolve(uniqueFileName + ".tmp");
        if (!currentTmpArchiveFilePath.toFile().exists()) {
            throw new IOException("Backup file with name " + uniqueFileName + " not found");
        }
        Files.move(currentTmpArchiveFilePath, currentArchiveFilePath, StandardCopyOption.ATOMIC_MOVE);
        WriteOrder writeOrder = new WriteOrder(this.bucketId, this.fileBucketId, LocalFileUtils.archiveFileNameRelativeToInputArchiveStorageFolder(this.fileBucketId, uniqueFileName), size, digest, uniqueFileName, QueueMessageType.WriteBackupOrder);
        this.writeOrderCreator.addToQueue(writeOrder);
    }
}

