/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.cas;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.mongodb.MongoException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.UpdateResult;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.storage.engine.common.model.TapeArchiveReferentialEntity;
import fr.gouv.vitam.storage.engine.common.model.TapeLibraryOnTapeArchiveStorageLocation;
import fr.gouv.vitam.storage.engine.common.model.TapeLibraryReadyOnDiskArchiveStorageLocation;
import fr.gouv.vitam.storage.offers.tape.exception.ArchiveReferentialException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.bson.Document;
import org.bson.conversions.Bson;

public class ArchiveReferentialRepository {
    private final MongoCollection<Document> collection;
    private final int bulkSize;

    public ArchiveReferentialRepository(MongoCollection<Document> collection) {
        this(collection, VitamConfiguration.getBatchSize());
    }

    @VisibleForTesting
    ArchiveReferentialRepository(MongoCollection<Document> collection, int bulkSize) {
        this.collection = collection;
        this.bulkSize = bulkSize;
    }

    public void insert(TapeArchiveReferentialEntity tapeArchiveReferentialEntity) throws ArchiveReferentialException {
        try {
            this.collection.insertOne((Object)this.toBson(tapeArchiveReferentialEntity));
        }
        catch (MongoException ex) {
            throw new ArchiveReferentialException("Could not insert or update archive referential for id " + tapeArchiveReferentialEntity.getArchiveId(), ex);
        }
    }

    public Optional<TapeArchiveReferentialEntity> find(String archiveId) throws ArchiveReferentialException {
        Document document;
        try {
            document = (Document)this.collection.find(Filters.eq((String)"_id", (Object)archiveId)).first();
        }
        catch (MongoException ex) {
            throw new ArchiveReferentialException("Could not find storage location by id " + archiveId, ex);
        }
        if (document == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.fromBson(document, TapeArchiveReferentialEntity.class));
        }
        catch (InvalidParseOperationException e) {
            throw new IllegalStateException("Could not parse document from DB " + BsonHelper.stringify((Document)document), e);
        }
    }

    public List<TapeArchiveReferentialEntity> bulkFind(Set<String> archiveIds) throws ArchiveReferentialException {
        if (archiveIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TapeArchiveReferentialEntity> result = new ArrayList<TapeArchiveReferentialEntity>();
        UnmodifiableIterator archiveIdBulkIterator = Iterators.partition(archiveIds.iterator(), (int)this.bulkSize);
        while (archiveIdBulkIterator.hasNext()) {
            try {
                MongoCursor documents = this.collection.find(Filters.in((String)"_id", (Iterable)((Iterable)archiveIdBulkIterator.next()))).cursor();
                try {
                    documents.forEachRemaining(document -> {
                        try {
                            result.add(this.fromBson((Document)document, (Class)TapeArchiveReferentialEntity.class));
                        }
                        catch (InvalidParseOperationException e) {
                            throw new IllegalStateException("Could not parse document from DB " + BsonHelper.stringify((Document)document), e);
                        }
                    });
                }
                finally {
                    if (documents == null) continue;
                    documents.close();
                }
            }
            catch (MongoException ex) {
                throw new ArchiveReferentialException("Could not find storage location by ids", ex);
            }
        }
        return result;
    }

    public void updateLocationToReadyOnDisk(String archiveId, long size, String digest) throws ArchiveReferentialException {
        try {
            UpdateResult updateResult = this.collection.updateOne(Filters.eq((String)"_id", (Object)archiveId), Updates.combine((Bson[])new Bson[]{Updates.set((String)"location", (Object)this.toBson(new TapeLibraryReadyOnDiskArchiveStorageLocation())), Updates.set((String)"size", (Object)size), Updates.set((String)"digest", (Object)digest), Updates.set((String)"lastUpdateDate", (Object)LocalDateUtil.nowFormatted())}), new UpdateOptions().upsert(false));
            if (updateResult.getMatchedCount() != 1L) {
                throw new ArchiveReferentialException("Could not update storage location for " + archiveId + ". No such archiveId");
            }
        }
        catch (MongoException ex) {
            throw new ArchiveReferentialException("Could not update storage location for " + archiveId, ex);
        }
    }

    public void updateLocationToOnTape(String archiveId, TapeLibraryOnTapeArchiveStorageLocation onTapeTarStorageLocation) throws ArchiveReferentialException {
        try {
            UpdateResult updateResult = this.collection.updateOne(Filters.eq((String)"_id", (Object)archiveId), Updates.combine((Bson[])new Bson[]{Updates.set((String)"location", (Object)this.toBson(onTapeTarStorageLocation)), Updates.set((String)"lastUpdateDate", (Object)LocalDateUtil.nowFormatted())}), new UpdateOptions().upsert(false));
            if (updateResult.getMatchedCount() != 1L) {
                throw new ArchiveReferentialException("Could not update storage location for " + archiveId + ". No such archiveId");
            }
        }
        catch (MongoException ex) {
            throw new ArchiveReferentialException("Could not update storage location for " + archiveId, ex);
        }
    }

    private Document toBson(Object object) {
        return Document.parse((String)JsonHandler.unprettyPrint((Object)object));
    }

    private <T> T fromBson(Document document, Class<T> clazz) throws InvalidParseOperationException {
        return (T)BsonHelper.fromDocumentToObject((Document)document, clazz);
    }
}

