/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.cas;

import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.performance.PerformanceLogger;
import fr.gouv.vitam.storage.engine.common.model.TapeLibraryObjectReferentialId;
import fr.gouv.vitam.storage.offers.tape.cache.LRUCacheEvictionJudge;
import fr.gouv.vitam.storage.offers.tape.cas.AccessRequestReferentialRepository;
import fr.gouv.vitam.storage.offers.tape.cas.ArchiveCacheEntry;
import fr.gouv.vitam.storage.offers.tape.cas.BucketTopologyHelper;
import fr.gouv.vitam.storage.offers.tape.cas.LockHandle;
import fr.gouv.vitam.storage.offers.tape.cas.LockManager;
import fr.gouv.vitam.storage.offers.tape.cas.ObjectReferentialRepository;
import fr.gouv.vitam.storage.offers.tape.exception.AccessRequestReferentialException;
import fr.gouv.vitam.storage.offers.tape.exception.ObjectReferentialException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;

public class ArchiveCacheEvictionController {
    private final AccessRequestReferentialRepository accessRequestReferentialRepository;
    private final ObjectReferentialRepository objectReferentialRepository;
    private final BucketTopologyHelper bucketTopologyHelper;
    private final LockManager<ArchiveCacheEntry> archiveCacheEntryLockManager;

    public ArchiveCacheEvictionController(AccessRequestReferentialRepository accessRequestReferentialRepository, ObjectReferentialRepository objectReferentialRepository, BucketTopologyHelper bucketTopologyHelper) {
        this.accessRequestReferentialRepository = accessRequestReferentialRepository;
        this.objectReferentialRepository = objectReferentialRepository;
        this.bucketTopologyHelper = bucketTopologyHelper;
        this.archiveCacheEntryLockManager = new LockManager();
    }

    public LRUCacheEvictionJudge<ArchiveCacheEntry> computeEvictionJudge() {
        Set<String> inUseArchiveIds = this.listArchiveIdsRequiredByActiveAccessRequests();
        return archiveCacheEntry -> {
            if (inUseArchiveIds.contains(archiveCacheEntry.getTarId())) {
                return false;
            }
            if (this.archiveCacheEntryLockManager.isLocked((ArchiveCacheEntry)archiveCacheEntry)) {
                return false;
            }
            boolean tarIdRequiredByActiveAccessRequests = this.bucketTopologyHelper.keepFileBucketIdForeverInCache(archiveCacheEntry.getFileBucketId());
            return !tarIdRequiredByActiveAccessRequests;
        };
    }

    private Set<String> listArchiveIdsRequiredByActiveAccessRequests() {
        try {
            Set<String> inUseArchiveIds;
            StopWatch swListObjects = StopWatch.createStarted();
            try (CloseableIterator<TapeLibraryObjectReferentialId> objectIdIterator = this.accessRequestReferentialRepository.listObjectIdsForActiveAccessRequests();){
                swListObjects.stop();
                PerformanceLogger.getInstance().log("TAPE_CACHE_EVICTION", "LIST_OBJECT_IDS_REQUIRED_BY_ACCESS_REQUESTS", swListObjects.getTime(TimeUnit.MILLISECONDS));
                StopWatch swListArchives = StopWatch.createStarted();
                inUseArchiveIds = this.objectReferentialRepository.selectArchiveIdsByObjectIds((Iterator<TapeLibraryObjectReferentialId>)objectIdIterator);
                swListArchives.stop();
                PerformanceLogger.getInstance().log("TAPE_CACHE_EVICTION", "LIST_ARCHIVE_IDS_REQUIRED_BY_ACCESS_REQUESTS", swListArchives.getTime(TimeUnit.MILLISECONDS));
            }
            return inUseArchiveIds;
        }
        catch (AccessRequestReferentialException | ObjectReferentialException e) {
            throw new RuntimeException("Could not list objectIds in use by active Access Requests", e);
        }
    }

    public LockHandle createLock(Set<ArchiveCacheEntry> archiveCacheEntries) {
        return this.archiveCacheEntryLockManager.createLock(archiveCacheEntries);
    }
}

