/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.offers.tape.cache;

import fr.gouv.vitam.common.ParametersChecker;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class LRUQueue<T> {
    private final Map<T, Long> lastAccessTimestamp = new HashMap<T, Long>();
    private final TreeSet<T> entries;

    public LRUQueue() {
        Comparator<Object> entryTimestampComparator = Comparator.comparing(this.lastAccessTimestamp::get);
        this.entries = new TreeSet<Object>(entryTimestampComparator);
    }

    public void add(T entry, long timestamp) throws IllegalArgumentException {
        ParametersChecker.checkParameter((String)"Null entry", (Object[])new Object[]{entry});
        if (this.lastAccessTimestamp.containsKey(entry)) {
            throw new IllegalArgumentException("Duplicate entry");
        }
        this.lastAccessTimestamp.put(entry, timestamp);
        this.entries.add(entry);
    }

    public boolean update(T entry, long timestamp) {
        ParametersChecker.checkParameter((String)"Null entry", (Object[])new Object[]{entry});
        if (!this.lastAccessTimestamp.containsKey(entry)) {
            return false;
        }
        this.entries.remove(entry);
        this.lastAccessTimestamp.put(entry, timestamp);
        this.entries.add(entry);
        return true;
    }

    public boolean contains(T entry) {
        return this.lastAccessTimestamp.containsKey(entry);
    }

    public boolean remove(T entry) {
        if (!this.lastAccessTimestamp.containsKey(entry)) {
            return false;
        }
        this.entries.remove(entry);
        this.lastAccessTimestamp.remove(entry);
        return true;
    }

    public Iterator<T> iterator() {
        final Iterator<T> queueIterator = this.entries.iterator();
        return new Iterator<T>(){
            private T lastEntry;

            @Override
            public boolean hasNext() {
                return queueIterator.hasNext();
            }

            @Override
            public T next() {
                this.lastEntry = queueIterator.next();
                return this.lastEntry;
            }

            @Override
            public void remove() {
                queueIterator.remove();
                LRUQueue.this.lastAccessTimestamp.remove(this.lastEntry);
            }
        };
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public int size() {
        return this.entries.size();
    }
}

