/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.operations.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.MongoCursor;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.CompareQuery;
import fr.gouv.vitam.common.database.builder.query.ExistsQuery;
import fr.gouv.vitam.common.database.builder.query.InQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.index.model.ReindexationKO;
import fr.gouv.vitam.common.database.index.model.ReindexationOK;
import fr.gouv.vitam.common.database.index.model.ReindexationResult;
import fr.gouv.vitam.common.database.index.model.SwitchIndexResult;
import fr.gouv.vitam.common.database.parameter.IndexParameters;
import fr.gouv.vitam.common.database.parser.query.ParserTokens;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchAccess;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexAlias;
import fr.gouv.vitam.common.database.server.elasticsearch.ElasticsearchIndexAliasResolver;
import fr.gouv.vitam.common.database.server.elasticsearch.IndexationHelper;
import fr.gouv.vitam.common.database.server.mongodb.VitamDocument;
import fr.gouv.vitam.common.database.server.mongodb.VitamMongoCursor;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.common.server.LogbookDbAccess;
import fr.gouv.vitam.logbook.common.server.config.ElasticsearchLogbookIndexManager;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookCollections;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbName;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookOperation;
import fr.gouv.vitam.logbook.common.server.exception.LogbookAlreadyExistsException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookDatabaseException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookNotFoundException;
import fr.gouv.vitam.logbook.operations.api.LogbookOperations;
import fr.gouv.vitam.logbook.operations.core.BackgroundLogbookTypeProcessHelper;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageAlreadyExistsClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.collections4.SetValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;

public class LogbookOperationsImpl
implements LogbookOperations {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookOperationsImpl.class);
    private final LogbookDbAccess mongoDbAccess;
    private final WorkspaceClientFactory workspaceClientFactory;
    private final StorageClientFactory storageClientFactory;
    private final IndexationHelper indexationHelper;
    private final ElasticsearchLogbookIndexManager indexManager;

    public LogbookOperationsImpl(LogbookDbAccess mongoDbAccess, ElasticsearchLogbookIndexManager indexManager) {
        this(mongoDbAccess, WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM), StorageClientFactory.getInstance(), IndexationHelper.getInstance(), indexManager);
    }

    @VisibleForTesting
    public LogbookOperationsImpl(LogbookDbAccess mongoDbAccess, WorkspaceClientFactory workspaceClientFactory, StorageClientFactory storageClientFactory, IndexationHelper indexationHelper, ElasticsearchLogbookIndexManager indexManager) {
        this.mongoDbAccess = mongoDbAccess;
        this.workspaceClientFactory = workspaceClientFactory;
        this.storageClientFactory = storageClientFactory;
        this.indexationHelper = indexationHelper;
        this.indexManager = indexManager;
    }

    @Override
    public void create(String operationId, LogbookOperationParameters ... parameters) throws LogbookAlreadyExistsException, LogbookDatabaseException {
        if (parameters == null || parameters.length == 0) {
            throw new IllegalArgumentException("No Logbook");
        }
        this.mongoDbAccess.createLogbookOperation(operationId, parameters);
        this.backupOperation(operationId);
    }

    @Override
    public void update(String operationId, LogbookOperationParameters ... parameters) throws LogbookNotFoundException, LogbookDatabaseException {
        if (parameters == null || parameters.length == 0) {
            throw new IllegalArgumentException("No Logbook");
        }
        this.mongoDbAccess.updateLogbookOperation(operationId, parameters);
        this.backupOperation(operationId);
    }

    @Override
    public List<LogbookOperation> selectOperations(JsonNode select) throws VitamDBException, LogbookDatabaseException {
        return this.selectOperations(select, false, false);
    }

    @Override
    public List<LogbookOperation> selectOperations(JsonNode select, boolean sliced, boolean crossTenant) throws VitamDBException, LogbookDatabaseException {
        VitamMongoCursor cursor = this.mongoDbAccess.getLogbookOperations(select, sliced, crossTenant);
        ArrayList<LogbookOperation> operations = new ArrayList<LogbookOperation>();
        while (cursor.hasNext()) {
            LogbookOperation doc = (LogbookOperation)cursor.next();
            this.filterFinalResponse((VitamDocument<?>)doc);
            operations.add(doc);
        }
        return operations;
    }

    @Override
    public RequestResponseOK<LogbookOperation> selectOperationsAsRequestResponse(JsonNode select, boolean sliced, boolean crossTenant) throws VitamDBException, LogbookDatabaseException {
        VitamMongoCursor cursor = this.mongoDbAccess.getLogbookOperations(select, sliced, crossTenant);
        ArrayList<LogbookOperation> operations = new ArrayList<LogbookOperation>();
        while (cursor.hasNext()) {
            LogbookOperation doc = (LogbookOperation)cursor.next();
            this.filterFinalResponse((VitamDocument<?>)doc);
            operations.add(doc);
        }
        return new RequestResponseOK(select, operations, (int)cursor.getTotal());
    }

    private void filterFinalResponse(VitamDocument<?> document) {
        block8: for (ParserTokens.PROJECTIONARGS projection : ParserTokens.PROJECTIONARGS.values()) {
            switch (projection) {
                case ID: {
                    this.replace(document, "_id", VitamFieldsHelper.id());
                    continue block8;
                }
                case TENANT: {
                    this.replace(document, "_tenant", VitamFieldsHelper.tenant());
                    continue block8;
                }
                case VERSION: {
                    this.replace(document, "_v", VitamFieldsHelper.version());
                    continue block8;
                }
                case LAST_PERSISTED_DATE: {
                    this.replace(document, "_lastPersistedDate", VitamFieldsHelper.lastPersistedDate());
                    continue block8;
                }
                case SEDAVERSION: {
                    this.replace(document, "_sedaVersion", VitamFieldsHelper.sedaVersion());
                    continue block8;
                }
                case IMPLEMENTATIONVERSION: {
                    this.replace(document, "_implementationVersion", VitamFieldsHelper.implementationVersion());
                    continue block8;
                }
            }
        }
    }

    private void replace(VitamDocument<?> document, String originalFieldName, String targetFieldName) {
        Object value = document.remove((Object)originalFieldName);
        if (value != null) {
            document.append(targetFieldName, value);
        }
    }

    @Override
    public LogbookOperation getById(String idProcess) throws LogbookDatabaseException, LogbookNotFoundException {
        return this.mongoDbAccess.getLogbookOperationById(idProcess);
    }

    @Override
    public LogbookOperation getById(String idProcess, JsonNode query, boolean sliced, boolean crossTenant) throws LogbookDatabaseException, LogbookNotFoundException {
        return this.mongoDbAccess.getLogbookOperationById(idProcess, query, sliced, crossTenant);
    }

    @Override
    public MongoCursor<LogbookOperation> selectOperationsByLastPersistenceDateInterval(LocalDateTime startDate, LocalDateTime endDate) throws LogbookDatabaseException, InvalidCreateOperationException, InvalidParseOperationException {
        Select select = new Select();
        select.setQuery((Query)QueryHelper.and().add(new Query[]{QueryHelper.gte((String)VitamFieldsHelper.lastPersistedDate(), (String)LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)startDate))}).add(new Query[]{QueryHelper.lte((String)VitamFieldsHelper.lastPersistedDate(), (String)LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)endDate))}));
        select.addOrderByAscFilter(new String[]{VitamFieldsHelper.lastPersistedDate()});
        VitamMongoCursor cursor = null;
        try {
            cursor = this.mongoDbAccess.getLogbookOperations((JsonNode)select.getFinalSelect(), false);
        }
        catch (VitamDBException e) {
            LOGGER.error((Throwable)e);
        }
        return cursor;
    }

    @Override
    public LogbookOperation findFirstTraceabilityOperationOKAfterDate(LocalDateTime date) throws InvalidCreateOperationException, LogbookDatabaseException {
        Select select = new Select();
        CompareQuery query = QueryHelper.gt((String)"evDateTime", (String)LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)date));
        CompareQuery type = QueryHelper.eq((String)"evTypeProc", (String)LogbookTypeProcess.TRACEABILITY.name());
        CompareQuery status = QueryHelper.eq((String)("events." + LogbookMongoDbName.outcomeDetail.getDbname()), (String)"STP_OP_SECURISATION.OK");
        select.setQuery((Query)QueryHelper.and().add(new Query[]{query, type, status}));
        select.setLimitFilter(0L, 1L);
        LogbookOperation logbookOperation = null;
        try {
            logbookOperation = (LogbookOperation)this.mongoDbAccess.getLogbookOperations((JsonNode)select.getFinalSelect(), false).next();
        }
        catch (VitamDBException e) {
            LOGGER.error((Throwable)e);
        }
        return logbookOperation;
    }

    @Override
    public LogbookOperation findLastTraceabilityOperationOK() throws InvalidCreateOperationException, LogbookDatabaseException, InvalidParseOperationException {
        Select select = new Select();
        CompareQuery type = QueryHelper.eq((String)"evTypeProc", (String)LogbookTypeProcess.TRACEABILITY.name());
        CompareQuery findEvent = QueryHelper.eq((String)String.format("%s.%s", "events", LogbookMongoDbName.outcomeDetail.getDbname()), (String)"STP_OP_SECURISATION.OK");
        select.setLimitFilter(0L, 1L);
        select.setQuery((Query)QueryHelper.and().add(new Query[]{type, findEvent}));
        select.addOrderByDescFilter(new String[]{"evDateTime"});
        try {
            return (LogbookOperation)this.mongoDbAccess.getLogbookOperations((JsonNode)select.getFinalSelect(), false).next();
        }
        catch (VitamDBException e) {
            throw new LogbookDatabaseException((Throwable)e);
        }
    }

    @Override
    public LogbookOperation findLastLifecycleTraceabilityOperation(String eventType, boolean traceabilityWithZipOnly) throws VitamException {
        try {
            Select query = new Select();
            CompareQuery type = QueryHelper.eq((String)"evTypeProc", (String)LogbookTypeProcess.TRACEABILITY.name());
            InQuery eventStatus = QueryHelper.in((String)String.format("%s.%s", "events", LogbookMongoDbName.outcomeDetail.getDbname()), (String[])new String[]{eventType + ".OK", eventType + ".WARNING"});
            BooleanQuery add = QueryHelper.and().add(new Query[]{type, eventStatus});
            if (traceabilityWithZipOnly) {
                ExistsQuery hasTraceabilityFile = QueryHelper.exists((String)"events.evDetData.FileName");
                add.add(new Query[]{hasTraceabilityFile});
            }
            query.setQuery((Query)add);
            query.setLimitFilter(0L, 1L);
            query.addOrderByDescFilter(new String[]{"evDateTime"});
            List<LogbookOperation> operations = this.selectOperations((JsonNode)query.getFinalSelect());
            if (operations.isEmpty()) {
                LOGGER.debug("Logbook not found, this is the first Operation of this type");
                return null;
            }
            return operations.get(0);
        }
        catch (InvalidCreateOperationException e) {
            throw new VitamException("Could not find last LFC traceability", (Throwable)e);
        }
    }

    @Override
    public Optional<LogbookOperation> findLastOperationByType(String operationType) throws InvalidCreateOperationException, LogbookDatabaseException, InvalidParseOperationException {
        Select select = new Select();
        CompareQuery type = QueryHelper.eq((String)"evType", (String)operationType);
        select.setQuery((Query)type);
        select.addOrderByDescFilter(new String[]{"evDateTime"});
        select.setLimitFilter(0L, 1L);
        try {
            return this.selectOperations((JsonNode)select.getFinalSelect()).stream().findFirst();
        }
        catch (VitamDBException e) {
            throw new LogbookDatabaseException((Throwable)e);
        }
    }

    @Override
    public ReindexationResult reindex(IndexParameters indexParameters) {
        LogbookCollections collection;
        try {
            collection = LogbookCollections.valueOf((String)indexParameters.getCollectionName().toUpperCase());
        }
        catch (IllegalArgumentException exc) {
            String message = "Invalid collection '" + indexParameters.getCollectionName() + "'";
            LOGGER.error(message, (Throwable)exc);
            return this.indexationHelper.getFullKOResult(indexParameters, message);
        }
        if (!LogbookCollections.OPERATION.equals((Object)collection)) {
            String message = String.format("Try to reindex a non operation logbook collection '%s' with operation logbook module", indexParameters.getCollectionName());
            LOGGER.error(message);
            return this.indexationHelper.getFullKOResult(indexParameters, message);
        }
        if (CollectionUtils.isEmpty((Collection)indexParameters.getTenants())) {
            String message = String.format("Missing tenants for %s collection reindexation", indexParameters.getCollectionName());
            LOGGER.error(message);
            return this.indexationHelper.getFullKOResult(indexParameters, message);
        }
        ReindexationResult reindexationResult = new ReindexationResult();
        reindexationResult.setCollectionName(indexParameters.getCollectionName());
        this.processDedicatedTenants(indexParameters, collection, reindexationResult);
        this.processGroupedTenants(indexParameters, collection, reindexationResult);
        return reindexationResult;
    }

    private void processDedicatedTenants(IndexParameters indexParameters, LogbookCollections collection, ReindexationResult reindexationResult) {
        ElasticsearchIndexAliasResolver indexAliasResolver = this.indexManager.getElasticsearchIndexAliasResolver(collection);
        List dedicatedTenantToProcess = indexParameters.getTenants().stream().filter(Predicate.not(arg_0 -> ((ElasticsearchLogbookIndexManager)this.indexManager).isGroupedTenant(arg_0))).collect(Collectors.toList());
        for (Integer tenantId : dedicatedTenantToProcess) {
            try {
                ReindexationOK reindexResult = this.indexationHelper.reindex(collection.getCollection(), (ElasticsearchAccess)collection.getEsClient(), indexAliasResolver.resolveIndexName(tenantId), this.indexManager.getElasticsearchIndexSettings(collection, tenantId.intValue()), collection.getElasticsearchCollection(), Collections.singletonList(tenantId), null);
                reindexationResult.addIndexOK(reindexResult);
            }
            catch (Exception exc) {
                String message = "Cannot reindex collection " + collection.name() + " for tenant " + tenantId + ". Unexpected error";
                LOGGER.error(message, (Throwable)exc);
                reindexationResult.addIndexKO(new ReindexationKO(Collections.singletonList(tenantId), null, message));
            }
        }
    }

    private void processGroupedTenants(IndexParameters indexParameters, LogbookCollections collection, ReindexationResult reindexationResult) {
        ElasticsearchIndexAliasResolver indexAliasResolver = this.indexManager.getElasticsearchIndexAliasResolver(collection);
        HashSetValuedHashMap tenantGroupTenantsMap = new HashSetValuedHashMap();
        indexParameters.getTenants().stream().filter(arg_0 -> ((ElasticsearchLogbookIndexManager)this.indexManager).isGroupedTenant(arg_0)).forEach(arg_0 -> this.lambda$processGroupedTenants$0((SetValuedMap)tenantGroupTenantsMap, arg_0));
        for (String tenantGroupName : tenantGroupTenantsMap.keySet()) {
            List allTenantGroupTenants = this.indexManager.getTenantGroupTenants(tenantGroupName);
            if (allTenantGroupTenants.size() == tenantGroupTenantsMap.get((Object)tenantGroupName).size()) continue;
            SetUtils.SetView missingTenants = SetUtils.difference(new HashSet(allTenantGroupTenants), (Set)tenantGroupTenantsMap.get((Object)tenantGroupName));
            LOGGER.warn("Missing tenants " + missingTenants + " of tenant group " + tenantGroupName + " will also be reindexed for collection " + collection);
        }
        TreeSet tenantGroupNamesToProcess = new TreeSet(tenantGroupTenantsMap.keySet());
        for (String tenantGroupName : tenantGroupNamesToProcess) {
            List tenantIds = this.indexManager.getTenantGroupTenants(tenantGroupName);
            try {
                ReindexationOK reindexResult = this.indexationHelper.reindex(collection.getCollection(), (ElasticsearchAccess)collection.getEsClient(), indexAliasResolver.resolveIndexName((Integer)tenantIds.get(0)), this.indexManager.getElasticsearchIndexSettings(collection, ((Integer)tenantIds.get(0)).intValue()), collection.getElasticsearchCollection(), tenantIds, tenantGroupName);
                reindexationResult.addIndexOK(reindexResult);
            }
            catch (Exception exc) {
                String message = "Cannot reindex collection " + collection.name() + " for tenant group " + tenantGroupName + ". Unexpected error";
                LOGGER.error(message, (Throwable)exc);
                reindexationResult.addIndexKO(new ReindexationKO(tenantIds, tenantGroupName, message));
            }
        }
    }

    @Override
    public SwitchIndexResult switchIndex(String alias, String newIndexName) throws DatabaseException {
        try {
            return this.indexationHelper.switchIndex(ElasticsearchIndexAlias.ofFullIndexName((String)alias), ElasticsearchIndexAlias.ofFullIndexName((String)newIndexName), (ElasticsearchAccess)LogbookCollections.OPERATION.getEsClient());
        }
        catch (DatabaseException exc) {
            LOGGER.error("Cannot switch alias {} to index {}", new Object[]{alias, newIndexName, exc});
            throw exc;
        }
    }

    @Override
    public boolean checkNewEligibleLogbookOperationsSinceLastTraceabilityOperation(LocalDateTime traceabilityStartDate, LocalDateTime traceabilityEndDate) throws LogbookDatabaseException {
        try {
            Select select = new Select();
            String[] ignoredBackgroundLogbookTypeProcesses = (String[])BackgroundLogbookTypeProcessHelper.getBackgroundLogbookTypeProcesses().stream().map(Enum::name).toArray(String[]::new);
            select.setQuery((Query)QueryHelper.and().add(new Query[]{QueryHelper.gte((String)VitamFieldsHelper.lastPersistedDate(), (String)LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)traceabilityStartDate))}).add(new Query[]{QueryHelper.lte((String)VitamFieldsHelper.lastPersistedDate(), (String)LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)traceabilityEndDate))}).add(new Query[]{QueryHelper.not().add(new Query[]{QueryHelper.in((String)"evTypeProc", (String[])ignoredBackgroundLogbookTypeProcesses)})}));
            select.setLimitFilter(0L, 1L);
            List<LogbookOperation> logbookOperations = this.selectOperations((JsonNode)select.getFinalSelect());
            if (logbookOperations.isEmpty()) {
                LOGGER.debug("No new logbook operations since last traceability");
            }
            return !logbookOperations.isEmpty();
        }
        catch (InvalidCreateOperationException | VitamDBException e) {
            throw new LogbookDatabaseException("Could not parse last traceability operation information", e);
        }
    }

    private void backupOperation(String operationGuid) throws LogbookDatabaseException {
        LogbookOperation logbookOperation;
        try {
            logbookOperation = this.mongoDbAccess.getLogbookOperationById(operationGuid);
        }
        catch (LogbookNotFoundException e) {
            throw new LogbookDatabaseException("Cannot find operation with GUID " + operationGuid + ", cannot backup it", (Throwable)e);
        }
        Integer tenantId = ParameterHelper.getTenantParameter();
        String containerName = tenantId + "_" + DataCategory.BACKUP_OPERATION.getFolder();
        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
            workspaceClient.createContainer(containerName);
            workspaceClient.putObject(containerName, operationGuid, JsonHandler.writeToInpustream((Object)logbookOperation));
            try (StorageClient storageClient = this.storageClientFactory.getClient();){
                ObjectDescription objectDescription = new ObjectDescription();
                objectDescription.setWorkspaceContainerGUID(containerName);
                objectDescription.setObjectName(operationGuid);
                objectDescription.setType(DataCategory.BACKUP_OPERATION);
                objectDescription.setWorkspaceObjectURI(operationGuid);
                storageClient.storeFileFromWorkspace(VitamConfiguration.getDefaultStrategy(), DataCategory.BACKUP_OPERATION, operationGuid, objectDescription);
            }
            catch (StorageAlreadyExistsClientException | StorageNotFoundClientException | StorageServerClientException e) {
                throw new LogbookDatabaseException("Cannot backup operation with GUID " + operationGuid, e);
            }
            workspaceClient.deleteObject(containerName, operationGuid);
        }
        catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException e) {
            LOGGER.warn("Cannot delete temporary backup operation file with GUID {}", (Object)operationGuid, (Object)e);
        }
        catch (InvalidParseOperationException e) {
            throw new LogbookDatabaseException("Cannot backup operation with GUID " + operationGuid, (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$processGroupedTenants$0(SetValuedMap tenantGroupTenantsMap, Integer tenantId) {
        tenantGroupTenantsMap.put((Object)this.indexManager.getTenantGroup(tenantId.intValue()), (Object)tenantId);
    }
}

