/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.operations.core;

import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class BackgroundLogbookTypeProcessHelper {
    private BackgroundLogbookTypeProcessHelper() {
    }

    public static List<LogbookTypeProcess> getBackgroundLogbookTypeProcesses() {
        return Arrays.stream(LogbookTypeProcess.values()).filter(BackgroundLogbookTypeProcessHelper::isBackgroundProcess).collect(Collectors.toList());
    }

    private static boolean isBackgroundProcess(LogbookTypeProcess logbookTypeProcess) {
        switch (logbookTypeProcess) {
            case TRACEABILITY: 
            case STORAGE_BACKUP: 
            case COMPUTE_INHERITED_RULES: 
            case DATA_CONSISTENCY_AUDIT: {
                return true;
            }
            case INGEST: 
            case INGEST_CLEANUP: 
            case AUDIT: 
            case DESTRUCTION: 
            case PRESERVATION: 
            case CHECK: 
            case UPDATE: 
            case MASTERDATA: 
            case INGEST_TEST: 
            case STORAGE_LOGBOOK: 
            case STORAGE_RULE: 
            case STORAGE_AGENCIES: 
            case HOLDINGSCHEME: 
            case FILINGSCHEME: 
            case EXPORT_DIP: 
            case ARCHIVE_TRANSFER: 
            case DATA_MIGRATION: 
            case RECLASSIFICATION: 
            case MASS_UPDATE: 
            case BULK_UPDATE: 
            case ELIMINATION: 
            case EXPORT_PROBATIVE_VALUE: 
            case EXTERNAL_LOGBOOK: 
            case TRANSFER_REPLY: 
            case COMPUTE_INHERITED_RULES_DELETE: 
            case INTERNAL_OPERATING_OP: 
            case DELETE_GOT_VERSIONS: {
                return false;
            }
        }
        throw new IllegalStateException("Unexpected value: " + logbookTypeProcess);
    }
}

