/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.operations.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.logbook.LogbookEvent;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookOperation;
import fr.gouv.vitam.logbook.common.server.exception.LogbookAlreadyExistsException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookDatabaseException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookNotFoundException;
import fr.gouv.vitam.logbook.operations.api.LogbookOperations;
import fr.gouv.vitam.logbook.operations.core.LogbookOperationsDecorator;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;

public class AlertLogbookOperationsDecorator
extends LogbookOperationsDecorator {
    private static final String SECURITY_ALERT = "Ev\u00e9nement de securit\u00e9 d\u00e9clench\u00e9 pour l''eventType {0} et l''outcome {1} : {2} {3}";
    private final List<LogbookEvent> alertEvents;
    private final AlertService alertService;

    public AlertLogbookOperationsDecorator(LogbookOperations logbookOperations, List<LogbookEvent> alertEvents) {
        super(logbookOperations);
        this.alertEvents = alertEvents;
        this.alertService = new AlertServiceImpl();
    }

    @VisibleForTesting
    AlertLogbookOperationsDecorator(LogbookOperations logbookOperations, List<LogbookEvent> alertEvents, AlertService alertService) {
        super(logbookOperations);
        this.alertEvents = alertEvents;
        this.alertService = alertService;
    }

    @Override
    public void create(String operationId, LogbookOperationParameters ... parameters) throws LogbookAlreadyExistsException, LogbookDatabaseException {
        this.logbookOperations.create(operationId, parameters);
        this.createAlertIfNecessary(parameters);
    }

    @Override
    public void update(String operationId, LogbookOperationParameters ... parameters) throws LogbookNotFoundException, LogbookDatabaseException {
        this.logbookOperations.update(operationId, parameters);
        this.createAlertIfNecessary(parameters);
    }

    @Override
    public List<LogbookOperation> selectOperations(JsonNode select) throws LogbookDatabaseException, InvalidParseOperationException, VitamDBException {
        return this.logbookOperations.selectOperations(select);
    }

    @Override
    public List<LogbookOperation> selectOperations(JsonNode select, boolean sliced, boolean crossTenant) throws VitamDBException, LogbookDatabaseException {
        return this.logbookOperations.selectOperations(select, sliced, crossTenant);
    }

    @Override
    public RequestResponseOK<LogbookOperation> selectOperationsAsRequestResponse(JsonNode select, boolean sliced, boolean crossTenant) throws VitamDBException, LogbookDatabaseException {
        return this.logbookOperations.selectOperationsAsRequestResponse(select, sliced, crossTenant);
    }

    @Override
    public LogbookOperation getById(String idProcess, JsonNode query, boolean sliced, boolean crossTenant) throws LogbookDatabaseException, LogbookNotFoundException {
        return this.logbookOperations.getById(idProcess, query, sliced, crossTenant);
    }

    @Override
    public LogbookOperation findLastLifecycleTraceabilityOperation(String eventType, boolean traceabilityWithZipOnly) throws VitamException {
        return this.logbookOperations.findLastLifecycleTraceabilityOperation(eventType, traceabilityWithZipOnly);
    }

    @Override
    public boolean checkNewEligibleLogbookOperationsSinceLastTraceabilityOperation(LocalDateTime traceabilityStartDate, LocalDateTime traceabilityEndDate) throws LogbookDatabaseException {
        return this.logbookOperations.checkNewEligibleLogbookOperationsSinceLastTraceabilityOperation(traceabilityStartDate, traceabilityEndDate);
    }

    @Override
    public Optional<LogbookOperation> findLastOperationByType(String operationType) throws InvalidCreateOperationException, LogbookDatabaseException, InvalidParseOperationException {
        return this.logbookOperations.findLastOperationByType(operationType);
    }

    private void createAlertIfNecessary(LogbookOperationParameters parameters) {
        if (this.isAlertEvent(parameters)) {
            String message = MessageFormat.format(SECURITY_ALERT, parameters.getParameterValue(LogbookParameterName.eventType), parameters.getParameterValue(LogbookParameterName.outcome), parameters.getParameterValue(LogbookParameterName.outcomeDetail), parameters.getParameterValue(LogbookParameterName.outcomeDetailMessage));
            this.alertService.createAlert(VitamLogLevel.INFO, message);
        }
    }

    private void createAlertIfNecessary(LogbookOperationParameters[] operationArray) {
        for (LogbookOperationParameters parameters : operationArray) {
            this.createAlertIfNecessary(parameters);
        }
    }

    @VisibleForTesting
    boolean isAlertEvent(LogbookOperationParameters parameters) {
        for (LogbookEvent logbookEvent : this.alertEvents) {
            if (logbookEvent.getOutDetail() != null) {
                String outDetail = parameters.getParameterValue(LogbookParameterName.outcomeDetail);
                if (Strings.isNullOrEmpty((String)outDetail)) {
                    return false;
                }
                if (!outDetail.equals(logbookEvent.getOutDetail())) continue;
                return true;
            }
            String eventType = parameters.getParameterValue(LogbookParameterName.eventType);
            if (Strings.isNullOrEmpty((String)eventType)) {
                return false;
            }
            String outcome = parameters.getParameterValue(LogbookParameterName.outcome);
            if (Strings.isNullOrEmpty((String)outcome)) {
                return false;
            }
            if (!eventType.equals(logbookEvent.getEvType()) || !outcome.equals(logbookEvent.getOutcome())) continue;
            return true;
        }
        return false;
    }
}

