/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.operations.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.mongodb.client.MongoCursor;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.index.model.ReindexationResult;
import fr.gouv.vitam.common.database.index.model.SwitchIndexResult;
import fr.gouv.vitam.common.database.parameter.IndexParameters;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookOperation;
import fr.gouv.vitam.logbook.common.server.exception.LogbookAlreadyExistsException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookDatabaseException;
import fr.gouv.vitam.logbook.common.server.exception.LogbookNotFoundException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;

public interface LogbookOperations {
    public void create(String var1, LogbookOperationParameters ... var2) throws LogbookAlreadyExistsException, LogbookDatabaseException;

    public void update(String var1, LogbookOperationParameters ... var2) throws LogbookNotFoundException, LogbookDatabaseException;

    public List<LogbookOperation> selectOperations(JsonNode var1) throws LogbookDatabaseException, InvalidParseOperationException, VitamDBException;

    public List<LogbookOperation> selectOperations(JsonNode var1, boolean var2, boolean var3) throws VitamDBException, LogbookDatabaseException;

    public RequestResponseOK<LogbookOperation> selectOperationsAsRequestResponse(JsonNode var1, boolean var2, boolean var3) throws VitamDBException, LogbookDatabaseException;

    public LogbookOperation getById(String var1) throws LogbookDatabaseException, LogbookNotFoundException;

    public LogbookOperation getById(String var1, JsonNode var2, boolean var3, boolean var4) throws LogbookDatabaseException, LogbookNotFoundException;

    public MongoCursor<LogbookOperation> selectOperationsByLastPersistenceDateInterval(LocalDateTime var1, LocalDateTime var2) throws LogbookDatabaseException, LogbookNotFoundException, InvalidParseOperationException, InvalidCreateOperationException;

    public LogbookOperation findFirstTraceabilityOperationOKAfterDate(LocalDateTime var1) throws InvalidCreateOperationException, LogbookNotFoundException, LogbookDatabaseException;

    public LogbookOperation findLastTraceabilityOperationOK() throws InvalidCreateOperationException, LogbookNotFoundException, LogbookDatabaseException, InvalidParseOperationException;

    public LogbookOperation findLastLifecycleTraceabilityOperation(String var1, boolean var2) throws VitamException;

    public ReindexationResult reindex(IndexParameters var1);

    public SwitchIndexResult switchIndex(String var1, String var2) throws DatabaseException;

    public boolean checkNewEligibleLogbookOperationsSinceLastTraceabilityOperation(LocalDateTime var1, LocalDateTime var2) throws LogbookDatabaseException;

    public Optional<LogbookOperation> findLastOperationByType(String var1) throws InvalidCreateOperationException, LogbookDatabaseException, InvalidParseOperationException;
}

