/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.InvalidJsonSchemaException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.json.JsonSchemaValidationException;
import fr.gouv.vitam.common.json.JsonSchemaValidator;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileModel;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileStatus;
import fr.gouv.vitam.metadata.core.validation.CachedArchiveUnitProfileLoader;
import fr.gouv.vitam.metadata.core.validation.CachedSchemaValidatorLoader;
import fr.gouv.vitam.metadata.core.validation.MetadataValidationErrorCode;
import fr.gouv.vitam.metadata.core.validation.MetadataValidationException;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.IteratorUtils;

public class UnitValidator {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(UnitValidator.class);
    private static final String JSON_SCHEMA_ARCHIVE_UNIT_SCHEMA_JSON = "/json-schema/archive-unit-schema.json";
    private final CachedArchiveUnitProfileLoader archiveUnitProfileLoader;
    private final CachedSchemaValidatorLoader schemaValidatorLoader;
    private final JsonSchemaValidator builtInSchemaValidator;

    public UnitValidator(CachedArchiveUnitProfileLoader archiveUnitProfileLoader, CachedSchemaValidatorLoader schemaValidatorLoader) {
        this.archiveUnitProfileLoader = archiveUnitProfileLoader;
        this.schemaValidatorLoader = schemaValidatorLoader;
        this.builtInSchemaValidator = JsonSchemaValidator.forBuiltInSchema((String)JSON_SCHEMA_ARCHIVE_UNIT_SCHEMA_JSON);
    }

    public void validateUnit(ObjectNode unitJson) throws MetadataValidationException {
        this.validateStartAndEndDates((JsonNode)unitJson);
        this.validateInternalSchema(unitJson);
        this.validateArchiveUnitProfile(unitJson);
    }

    public void validateInternalSchema(ObjectNode archiveUnit) throws MetadataValidationException {
        try {
            this.builtInSchemaValidator.validateJson((JsonNode)archiveUnit);
        }
        catch (JsonSchemaValidationException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Unit validation failed: " + e.getMessage() + "\n" + JsonHandler.unprettyPrint((Object)archiveUnit));
            }
            throw new MetadataValidationException(MetadataValidationErrorCode.SCHEMA_VALIDATION_FAILURE, "Invalid unit format : " + e.getMessage(), e);
        }
    }

    public void validateArchiveUnitProfile(ObjectNode archiveUnit) throws MetadataValidationException {
        JsonNode archiveUnitProfileNode = archiveUnit.get("ArchiveUnitProfile");
        if (archiveUnitProfileNode != null) {
            String aupId = archiveUnitProfileNode.textValue();
            Optional<ArchiveUnitProfileModel> archiveUnitProfile = this.archiveUnitProfileLoader.loadArchiveUnitProfile(aupId);
            if (!archiveUnitProfile.isPresent()) {
                throw new MetadataValidationException(MetadataValidationErrorCode.UNKNOWN_ARCHIVE_UNIT_PROFILE, "Archive Unit Profile not found");
            }
            this.validateArchiveUnitProfile(archiveUnitProfile.get());
            try {
                JsonSchemaValidator externalSchemaValidator = this.schemaValidatorLoader.loadSchemaValidator(archiveUnitProfile.get().getControlSchema());
                ObjectNode normalizedArchiveUnit = this.normalizeArchiveUnitForArchiveUnitProfileValidation(archiveUnit);
                externalSchemaValidator.validateJson((JsonNode)normalizedArchiveUnit);
            }
            catch (JsonSchemaValidationException e) {
                throw new MetadataValidationException(MetadataValidationErrorCode.ARCHIVE_UNIT_PROFILE_SCHEMA_VALIDATION_FAILURE, "Archive unit profile validation failed: " + e.getMessage(), e);
            }
            catch (InvalidJsonSchemaException e) {
                throw new VitamRuntimeException("Invalid ArchiveUnitProfile", (Throwable)e);
            }
        }
    }

    private ObjectNode normalizeArchiveUnitForArchiveUnitProfileValidation(ObjectNode archiveUnit) {
        ObjectNode result = JsonHandler.createObjectNode();
        for (Map.Entry entry : IteratorUtils.asIterable((Iterator)archiveUnit.fields())) {
            if (!((String)entry.getKey()).startsWith("_")) {
                result.set((String)entry.getKey(), (JsonNode)entry.getValue());
                continue;
            }
            if (!((String)entry.getKey()).equals("_mgt")) continue;
            result.set(VitamFieldsHelper.management(), (JsonNode)entry.getValue());
        }
        return result;
    }

    private void validateArchiveUnitProfile(ArchiveUnitProfileModel archiveUnitProfile) throws MetadataValidationException {
        if (archiveUnitProfile.getStatus() != ArchiveUnitProfileStatus.ACTIVE) {
            throw new MetadataValidationException(MetadataValidationErrorCode.ARCHIVE_UNIT_PROFILE_SCHEMA_INACTIVE, "Unit ArchiveUnitProfile is inactive");
        }
        if (UnitValidator.isControlSchemaEmpty(archiveUnitProfile)) {
            throw new MetadataValidationException(MetadataValidationErrorCode.EMPTY_ARCHIVE_UNIT_PROFILE_SCHEMA, "Archive unit profile does not have a controlSchema");
        }
    }

    private static boolean isControlSchemaEmpty(ArchiveUnitProfileModel archiveUnitProfile) {
        try {
            return archiveUnitProfile.getControlSchema() == null || JsonHandler.isEmpty((String)archiveUnitProfile.getControlSchema());
        }
        catch (InvalidParseOperationException e) {
            throw new RuntimeException("Invalid archive unit profile", e);
        }
    }

    public void validateStartAndEndDates(JsonNode archiveUnit) throws MetadataValidationException {
        if (archiveUnit.get("StartDate") != null && archiveUnit.get("EndDate") != null) {
            Date endDate;
            Date startDate;
            try {
                startDate = LocalDateUtil.getDate((String)archiveUnit.get("StartDate").asText());
                endDate = LocalDateUtil.getDate((String)archiveUnit.get("EndDate").asText());
            }
            catch (ParseException e) {
                throw new MetadataValidationException(MetadataValidationErrorCode.INVALID_UNIT_DATE_FORMAT, "Invalid unit start/end dates", e);
            }
            if (endDate.before(startDate)) {
                throw new MetadataValidationException(MetadataValidationErrorCode.INVALID_START_END_DATE, "EndDate is before StartDate");
            }
        }
    }
}

