/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.validation;

import com.amazonaws.util.CollectionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import fr.gouv.vitam.common.CharsetUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.client.OntologyLoader;
import fr.gouv.vitam.common.date.converter.XsdDateToMongoConverter;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitam.metadata.core.validation.MetadataValidationErrorCode;
import fr.gouv.vitam.metadata.core.validation.MetadataValidationException;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;

public class OntologyValidator {
    private static float MAX_UTF8_BYTES_PER_CHAR = StandardCharsets.UTF_8.newEncoder().maxBytesPerChar();
    private final OntologyLoader ontologyLoader;

    public OntologyValidator(OntologyLoader ontologyLoader) {
        this.ontologyLoader = ontologyLoader;
    }

    public ObjectNode verifyAndReplaceFields(JsonNode jsonNode) throws MetadataValidationException {
        ObjectNode transformedJsonNode = (ObjectNode)jsonNode.deepCopy();
        List ontologyModels = this.ontologyLoader.loadOntologies();
        Map<String, OntologyModel> ontologyModelMap = ontologyModels.stream().collect(Collectors.toMap(OntologyModel::getIdentifier, oM -> oM));
        ArrayList<String> errors = new ArrayList<String>();
        Iterator iterator = transformedJsonNode.fields();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.verifyLine((JsonNode)transformedJsonNode, ontologyModelMap, errors, entry);
        }
        if (!errors.isEmpty()) {
            String error = "metadata contains fields declared in ontology with a wrong format : " + CollectionUtils.join(errors, (String)",");
            throw new MetadataValidationException(MetadataValidationErrorCode.ONTOLOGY_VALIDATION_FAILURE, error);
        }
        return transformedJsonNode;
    }

    private void verifyAndReplaceFields(JsonNode node, Map<String, OntologyModel> ontologyModelMap, List<String> errors) {
        Iterator iterator = node.fields();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.verifyLine(node, ontologyModelMap, errors, entry);
        }
    }

    private void verifyLine(JsonNode node, Map<String, OntologyModel> ontologyModelMap, List<String> errors, Map.Entry<String, JsonNode> entry) {
        String fieldName = entry.getKey();
        OntologyModel ontology = ontologyModelMap.get(fieldName);
        JsonNode fieldValue = entry.getValue();
        if (fieldValue == null || fieldValue.isMissingNode()) {
            return;
        }
        if (fieldValue.isObject()) {
            this.verifyAndReplaceFields(fieldValue, ontologyModelMap, errors);
            return;
        }
        if (fieldValue.isArray()) {
            for (int i = 0; i < fieldValue.size(); ++i) {
                JsonNode jn = fieldValue.get(i);
                this.verifyField(ontologyModelMap, errors, fieldName, ontology, (ArrayNode)fieldValue, i, jn);
            }
            return;
        }
        errors.addAll(this.replacePropertyField(fieldValue, ontology, node, fieldName));
    }

    private void verifyField(Map<String, OntologyModel> ontologyModelMap, List<String> errors, String fieldName, OntologyModel ontology, ArrayNode fieldValue, int i, JsonNode jn) {
        if (null == jn || null == jn.asText()) {
            return;
        }
        if (jn.isObject() || jn.isArray()) {
            this.verifyAndReplaceFields(jn, ontologyModelMap, errors);
            return;
        }
        try {
            fieldValue.set(i, this.checkFieldLengthAndForceFieldTyping(fieldName, jn, ontology));
        }
        catch (IllegalArgumentException | DateTimeParseException e) {
            errors.add(String.format("Error '%s' on field '%s'.", e.getMessage(), fieldName));
        }
    }

    private List<String> replacePropertyField(JsonNode fieldValue, OntologyModel ontology, JsonNode fieldContainer, String fieldName) {
        ObjectNode objectNodeContainer = (ObjectNode)fieldContainer;
        if (!fieldValue.isNull() && !fieldValue.isMissingNode()) {
            try {
                objectNodeContainer.set(fieldName, this.checkFieldLengthAndForceFieldTyping(fieldName, fieldValue, ontology));
            }
            catch (IllegalArgumentException | DateTimeParseException e) {
                return Collections.singletonList(String.format("Error: <%s> on field '%s'.", e.getMessage(), fieldName));
            }
        }
        return Collections.emptyList();
    }

    private JsonNode checkFieldLengthAndForceFieldTyping(String fieldName, JsonNode fieldValueNode, OntologyModel ontologyModel) {
        if (fieldName.startsWith("_")) {
            return fieldValueNode;
        }
        if (null == ontologyModel) {
            return this.validateValueLength(fieldName, fieldValueNode, VitamConfiguration.getTextMaxLength(), "Not accepted value for the text field (%s) whose UTF8 encoding is longer than the max length " + VitamConfiguration.getTextMaxLength());
        }
        switch (ontologyModel.getType()) {
            case TEXT: {
                return this.validateValueLength(fieldName, fieldValueNode, VitamConfiguration.getTextMaxLength(), "Not accepted value for the text field (%s) whose UTF8 encoding is longer than the max length " + VitamConfiguration.getTextMaxLength());
            }
            case GEO_POINT: 
            case ENUM: 
            case KEYWORD: {
                return this.validateValueLength(fieldName, fieldValueNode, VitamConfiguration.getKeywordMaxLength(), "Not accepted value for the Keyword field (%s) whose UTF8 encoding is longer than the max length " + VitamConfiguration.getTextMaxLength());
            }
            case DOUBLE: {
                if (fieldValueNode.isDouble()) {
                    return fieldValueNode;
                }
                return new DoubleNode(Double.parseDouble(fieldValueNode.asText()));
            }
            case DATE: {
                return new TextNode(this.mapDateToOntology(fieldValueNode.asText()));
            }
            case LONG: {
                if (fieldValueNode.isLong()) {
                    return fieldValueNode;
                }
                return new LongNode(Long.parseLong(fieldValueNode.asText()));
            }
            case BOOLEAN: {
                if (fieldValueNode.isBoolean()) {
                    return fieldValueNode;
                }
                return BooleanNode.valueOf((boolean)BooleanUtils.toBoolean((String)fieldValueNode.asText().toLowerCase(), (String)"true", (String)"false"));
            }
        }
        throw new IllegalStateException(String.format("Not implemented for type %s", fieldValueNode.asText()));
    }

    private JsonNode validateValueLength(String fieldName, JsonNode fieldValueNode, int maxUtf8Length, String message) {
        if (null == fieldValueNode) {
            return null;
        }
        String textValue = fieldValueNode.asText();
        if (OntologyValidator.stringExceedsMaxLuceneUtf8StorageSize(textValue, maxUtf8Length)) {
            throw new IllegalArgumentException(String.format(message, fieldName));
        }
        if (fieldValueNode.isTextual()) {
            return fieldValueNode;
        }
        return new TextNode(textValue);
    }

    public static boolean stringExceedsMaxLuceneUtf8StorageSize(String textValue, int maxUtf8Length) {
        if ((float)textValue.length() * MAX_UTF8_BYTES_PER_CHAR < (float)maxUtf8Length) {
            return false;
        }
        return textValue.getBytes(CharsetUtils.UTF8).length >= maxUtf8Length;
    }

    private String mapDateToOntology(String input) {
        XsdDateToMongoConverter xsdDateToMongoConverter = new XsdDateToMongoConverter();
        return xsdDateToMongoConverter.mapDateXmlToMongo(input);
    }
}

