/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.validation;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import fr.gouv.vitam.common.json.InvalidJsonSchemaException;
import fr.gouv.vitam.common.json.JsonSchemaValidator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class CachedSchemaValidatorLoader {
    private final Cache<String, JsonSchemaValidator> schemaValidatorCache;

    public CachedSchemaValidatorLoader(int maxEntriesInCache, int cacheTimeoutInSeconds) {
        CacheBuilder objectObjectCacheBuilder = CacheBuilder.newBuilder();
        objectObjectCacheBuilder.maximumSize((long)maxEntriesInCache);
        objectObjectCacheBuilder.expireAfterAccess((long)cacheTimeoutInSeconds, TimeUnit.SECONDS);
        objectObjectCacheBuilder.weakValues();
        this.schemaValidatorCache = objectObjectCacheBuilder.build();
    }

    public JsonSchemaValidator loadSchemaValidator(String jsonSchema) throws InvalidJsonSchemaException {
        try {
            return (JsonSchemaValidator)this.schemaValidatorCache.get((Object)jsonSchema, () -> JsonSchemaValidator.forUserSchema((String)jsonSchema));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InvalidJsonSchemaException) {
                throw (InvalidJsonSchemaException)e.getCause();
            }
            throw new InvalidJsonSchemaException("Could not load schema validator", (Throwable)e);
        }
    }
}

