/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.validation;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileModel;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialNotFoundException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class CachedArchiveUnitProfileLoader {
    private final AdminManagementClientFactory adminManagementClientFactory;
    private final LoadingCache<String, Optional<ArchiveUnitProfileModel>> archiveUnitProfileCache;

    public CachedArchiveUnitProfileLoader(AdminManagementClientFactory adminManagementClientFactory, int maxEntriesInCache, int cacheTimeoutInSeconds) {
        this.adminManagementClientFactory = adminManagementClientFactory;
        CacheBuilder objectObjectCacheBuilder = CacheBuilder.newBuilder();
        objectObjectCacheBuilder.maximumSize((long)maxEntriesInCache);
        objectObjectCacheBuilder.expireAfterAccess((long)cacheTimeoutInSeconds, TimeUnit.SECONDS);
        objectObjectCacheBuilder.weakValues();
        this.archiveUnitProfileCache = objectObjectCacheBuilder.build((CacheLoader)new CacheLoader<String, Optional<ArchiveUnitProfileModel>>(){

            public Optional<ArchiveUnitProfileModel> load(String key) {
                String aupId = key.substring(key.indexOf(47) + 1);
                return CachedArchiveUnitProfileLoader.this.loadArchiveUnitProfileFromAdminManagement(aupId);
            }
        });
    }

    public Optional<ArchiveUnitProfileModel> loadArchiveUnitProfile(String aupId) {
        String requestId = VitamThreadUtils.getVitamSession().getRequestId();
        return (Optional)this.archiveUnitProfileCache.getUnchecked((Object)(requestId + "/" + aupId));
    }

    private Optional<ArchiveUnitProfileModel> loadArchiveUnitProfileFromAdminManagement(String aupId) {
        Optional<ArchiveUnitProfileModel> optional;
        block11: {
            AdminManagementClient adminClient = this.adminManagementClientFactory.getClient();
            try {
                RequestResponse aup = adminClient.findArchiveUnitProfilesByID(aupId);
                if (!aup.isOk()) {
                    throw new VitamRuntimeException("Could not load ArchiveUnitProfile");
                }
                optional = Optional.of((ArchiveUnitProfileModel)((RequestResponseOK)aup).getFirstResult());
                if (adminClient == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (adminClient != null) {
                        try {
                            adminClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialNotFoundException e) {
                    return Optional.empty();
                }
                catch (AdminManagementClientServerException e) {
                    throw new VitamRuntimeException("Could not load ArchiveUnitProfile", (Throwable)e);
                }
                catch (InvalidParseOperationException e) {
                    throw new IllegalStateException("Invalid ArchiveUnitProfile", e);
                }
            }
            adminClient.close();
        }
        return optional;
    }
}

