/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.utils;

import org.elasticsearch.search.aggregations.bucket.nested.Nested;
import org.elasticsearch.search.aggregations.metrics.ParsedSum;
import org.elasticsearch.search.aggregations.metrics.ParsedValueCount;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.elasticsearch.search.aggregations.metrics.ValueCount;

public class OriginatingAgencyBucketResult {
    public final String originatingAgency;
    public final long docCount;
    public final long objectCount;
    public final double binaryObjectSize;

    private OriginatingAgencyBucketResult(String originatingAgency, long docCount, ValueCount objectCount, Sum binaryObjectSize) {
        this.originatingAgency = originatingAgency;
        this.docCount = docCount;
        this.objectCount = objectCount.getValue();
        this.binaryObjectSize = binaryObjectSize.getValue();
    }

    public static OriginatingAgencyBucketResult empty() {
        return new OriginatingAgencyBucketResult("", 0L, (ValueCount)new ParsedValueCount(), (Sum)new ParsedSum());
    }

    public static OriginatingAgencyBucketResult of(String originatingAgency, long docCount, Nested nestedVersions) {
        return new OriginatingAgencyBucketResult(originatingAgency, docCount, (ValueCount)nestedVersions.getAggregations().get("binaryObjectCount"), (Sum)nestedVersions.getAggregations().get("binaryObjectSize"));
    }
}

