/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.parser.request.multiple.RequestParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.metadata.core.database.collections.Result;
import java.util.List;
import java.util.Map;

public final class MetadataJsonResponseUtils {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MetadataJsonResponseUtils.class);

    private MetadataJsonResponseUtils() {
    }

    public static ArrayNode populateJSONObjectResponse(Result result, RequestParserMultiple selectRequest) throws InvalidParseOperationException {
        ArrayNode jsonListResponse = JsonHandler.createArrayNode();
        if (result != null && result.getNbResult() > 0L && selectRequest instanceof SelectParserMultiple && result.hasFinalResult()) {
            LOGGER.debug("Result document: " + result.getFinal().toString());
            jsonListResponse = (ArrayNode)MetadataJsonResponseUtils.getMetadataJsonObject(result.getListFiltered());
        }
        LOGGER.debug("MetaDataImpl / selectUnitsByQuery /Results: " + jsonListResponse.toString());
        return jsonListResponse;
    }

    private static JsonNode getMetadataJsonObject(Object unitOrObjectGroup) throws InvalidParseOperationException {
        return JsonHandler.toJsonNode((Object)unitOrObjectGroup);
    }

    public static ArrayNode populateJSONObjectResponse(Result result, Map<String, List<String>> diff) {
        ArrayNode arrayJsonListResponse = JsonHandler.createArrayNode();
        if (result != null && result.getNbResult() > 0L) {
            arrayJsonListResponse = MetadataJsonResponseUtils.getJsonDiff(diff);
        }
        LOGGER.debug("populateJSONObjectResponse: " + arrayJsonListResponse.toString());
        return arrayJsonListResponse;
    }

    private static ArrayNode getJsonDiff(Map<String, List<String>> diff) {
        ArrayNode diffArrayNode = JsonHandler.createArrayNode();
        for (String id : diff.keySet()) {
            ObjectNode diffNode = JsonHandler.createObjectNode();
            diffNode.put("#id", id);
            diffNode.put("#diff", String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)diff.get(id)));
            diffArrayNode.add((JsonNode)diffNode);
        }
        return diffArrayNode;
    }
}

