/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.trigger;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.metadata.core.trigger.JsonPath;
import java.util.List;

public class History {
    protected static final String _HISTORY = "_history";
    protected static final String _V = "_v";
    private static final String UD = "ud";
    private static final String DATA = "data";
    private final List<String> splitPathForHistory;
    private final String namePathForHistory;
    private final long version;
    private final JsonNode nodeToHistory;

    public History(String objectPathForHistory, long version, JsonNode nodeToHistory) {
        this.splitPathForHistory = JsonPath.getSplitPath(objectPathForHistory);
        this.namePathForHistory = JsonPath.getTargetOfPath(objectPathForHistory);
        this.version = version;
        this.nodeToHistory = nodeToHistory;
    }

    public JsonNode getArrayNode() {
        ArrayNode historyArray = JsonHandler.createArrayNode();
        ObjectNode history = JsonHandler.createObjectNode();
        historyArray.add((JsonNode)history);
        history.put(UD, LocalDateUtil.nowFormatted());
        ObjectNode data = history.putObject(DATA);
        data.put(_V, this.version);
        if (this.nodeToHistory.isMissingNode()) {
            this.createBranch(data);
        } else {
            this.createBranch(data).set(this.namePathForHistory, this.nodeToHistory);
        }
        return historyArray;
    }

    public JsonNode getNode() {
        ObjectNode history = JsonHandler.createObjectNode();
        history.put(UD, LocalDateUtil.nowFormatted());
        ObjectNode data = history.putObject(DATA);
        data.put(_V, this.version);
        this.createBranch(data).set(this.namePathForHistory, this.nodeToHistory);
        return history;
    }

    private ObjectNode createBranch(ObjectNode root) {
        ObjectNode currentNode = root;
        for (String nodeName : this.splitPathForHistory) {
            currentNode = currentNode.putObject(nodeName);
        }
        return currentNode;
    }
}

