/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.trigger;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.metadata.core.trigger.ChangesHistory;
import fr.gouv.vitam.metadata.core.trigger.ChangesTriggerConfigFileException;
import fr.gouv.vitam.metadata.core.trigger.HistoryTriggerConfig;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FieldHistoryManager {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(FieldHistoryManager.class);
    private final Map<String, ChangesHistory> triggers = new HashMap<String, ChangesHistory>();

    public FieldHistoryManager(String fileNameTriggersConfig) {
        try {
            for (HistoryTriggerConfig config : (HistoryTriggerConfig[])JsonHandler.getFromInputStream((InputStream)PropertiesUtils.getResourceAsStream((String)fileNameTriggersConfig), HistoryTriggerConfig[].class)) {
                if (this.triggers.get(config.getFieldPathTriggeredForHistory()) != null) continue;
                this.triggers.put(config.getFieldPathTriggeredForHistory(), new ChangesHistory(config.getObjectPathForHistory()));
            }
        }
        catch (InvalidParseOperationException | FileNotFoundException e) {
            LOGGER.error(e);
            throw new ChangesTriggerConfigFileException(e);
        }
    }

    public void trigger(JsonNode unitBeforeChanges, JsonNode unitAfterChanges) {
        for (Map.Entry<String, ChangesHistory> trigger : this.triggers.entrySet()) {
            if (!this.isUpdatedFieldForHistory(trigger.getKey(), unitBeforeChanges, unitAfterChanges)) continue;
            trigger.getValue().addHistory(unitBeforeChanges, unitAfterChanges);
        }
    }

    private boolean isUpdatedFieldForHistory(String fieldPathForHistory, JsonNode unitBeforeUpdate, JsonNode unitAfterUpdate) {
        String valueAfterUpdate;
        String valueBeforeUpdate = this.getValue(fieldPathForHistory, unitBeforeUpdate);
        return !StringUtils.equals((CharSequence)valueBeforeUpdate, (CharSequence)(valueAfterUpdate = this.getValue(fieldPathForHistory, unitAfterUpdate)));
    }

    private String getValue(String fieldForHistorical, JsonNode unit) {
        JsonNode node = JsonHandler.findNode((JsonNode)unit, (String)fieldForHistorical);
        if (node.isMissingNode()) {
            return null;
        }
        return node.asText();
    }
}

