/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.trigger;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.metadata.core.trigger.History;

public class ChangesHistory {
    private static final String UNIT_VERSION = "_v";
    private final String objectPathForHistory;

    public ChangesHistory(String objectPathForHistory) {
        this.objectPathForHistory = objectPathForHistory;
    }

    public void addHistory(JsonNode unitBeforeUpdate, JsonNode unitAfterUpdate) {
        JsonNode objectToHistory = JsonHandler.findNode((JsonNode)unitBeforeUpdate, (String)this.objectPathForHistory);
        JsonNode historyNode = unitAfterUpdate.findPath("_history");
        History history = new History(this.objectPathForHistory, this.getUnitVersion(unitBeforeUpdate), objectToHistory);
        if (historyNode.isMissingNode()) {
            ((ObjectNode)unitAfterUpdate).set("_history", history.getArrayNode());
        } else {
            ((ArrayNode)historyNode).add(history.getNode());
        }
    }

    private long getUnitVersion(JsonNode unitBeforeUpdate) {
        JsonNode versionNode = unitBeforeUpdate.path(UNIT_VERSION);
        if (versionNode.isMissingNode()) {
            return 0L;
        }
        return versionNode.asLong();
    }
}

