/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.rules;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.parser.request.multiple.RequestParserHelper;
import fr.gouv.vitam.common.database.parser.request.multiple.RequestParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.rules.UnitInheritedRulesResponseModel;
import fr.gouv.vitam.common.model.rules.UnitRuleModel;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.api.exception.MetaDataNotFoundException;
import fr.gouv.vitam.metadata.core.MetaDataImpl;
import fr.gouv.vitam.metadata.core.model.MetadataResult;
import fr.gouv.vitam.metadata.core.rules.ComputeInheritedRuleService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MetadataRuleService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MetadataRuleService.class);
    private static final int MAX_PRINTED_MISSING_UNITS = 10;
    public static final String INHERITED_RULES = "InheritedRules";
    private static final int MAX_ELASTIC_SEARCH_IN_REQUEST_SIZE = 1000;
    private final ComputeInheritedRuleService computeInheritedRuleService;
    private final MetaDataImpl metaData;

    public MetadataRuleService(MetaDataImpl metaData) {
        this(new ComputeInheritedRuleService(), metaData);
    }

    @VisibleForTesting
    MetadataRuleService(ComputeInheritedRuleService computeInheritedRuleService, MetaDataImpl metaData) {
        this.computeInheritedRuleService = computeInheritedRuleService;
        this.metaData = metaData;
    }

    public MetadataResult selectUnitsWithInheritedRules(JsonNode selectQuery) throws InvalidParseOperationException, MetaDataExecutionException, BadRequestException, VitamDBException, MetaDataNotFoundException, MetaDataDocumentSizeException {
        LOGGER.debug("selectUnitsWithInheritedRules / selectQuery: " + selectQuery);
        RequestParserMultiple parser = RequestParserHelper.getParser((JsonNode)selectQuery);
        if (!(parser instanceof SelectParserMultiple)) {
            throw new InvalidParseOperationException("Expected a select query");
        }
        SelectMultiQuery request = (SelectMultiQuery)parser.getRequest();
        ObjectNode fieldsProjection = (ObjectNode)request.getProjection().get(BuilderToken.PROJECTION.FIELDS.exactToken());
        if (fieldsProjection != null && fieldsProjection.size() > 0) {
            if (fieldsProjection.has(BuilderToken.GLOBAL.RULES.exactToken())) {
                throw new InvalidParseOperationException("Invalid " + BuilderToken.GLOBAL.RULES.exactToken() + " projection");
            }
            fieldsProjection.put(VitamFieldsHelper.id(), 1);
        }
        MetadataResult metadataResult = this.metaData.selectUnitsByQuery((JsonNode)request.getFinalSelect());
        this.computeInheritedRulesForUnits(metadataResult.getResults());
        return metadataResult;
    }

    private void computeInheritedRulesForUnits(List<JsonNode> results) throws InvalidParseOperationException, MetaDataNotFoundException, MetaDataDocumentSizeException, MetaDataExecutionException, BadRequestException, VitamDBException {
        ArrayList<String> unitIds = new ArrayList<String>();
        for (JsonNode jsonNode : results) {
            unitIds.add(jsonNode.get(VitamFieldsHelper.id()).asText());
        }
        Map<String, UnitRuleModel> unitRulesByIdsMap = this.loadUnitRuleHierarchy(unitIds);
        Map<String, UnitInheritedRulesResponseModel> inheritedRules = this.computeInheritedRuleService.computeInheritedRules(unitRulesByIdsMap);
        for (JsonNode jsonNode : results) {
            String id = jsonNode.get(VitamFieldsHelper.id()).asText();
            ((ObjectNode)jsonNode).set(INHERITED_RULES, JsonHandler.toJsonNode((Object)inheritedRules.get(id)));
        }
    }

    private Map<String, UnitRuleModel> loadUnitRuleHierarchy(Collection<String> unitIds) throws InvalidParseOperationException, MetaDataNotFoundException, MetaDataDocumentSizeException, MetaDataExecutionException, BadRequestException, VitamDBException {
        HashMap<String, UnitRuleModel> unitRulesById = new HashMap<String, UnitRuleModel>();
        HashSet<String> unitsToLoad = new HashSet<String>(unitIds);
        while (!unitsToLoad.isEmpty()) {
            Set<String> bulkIds = unitsToLoad.stream().limit(1000L).collect(Collectors.toSet());
            for (String bulkId : bulkIds) {
                unitRulesById.put(bulkId, null);
            }
            List<UnitRuleModel> foundUnitRules = this.loadBulkUnitRules(bulkIds);
            for (UnitRuleModel unitRuleModel : foundUnitRules) {
                unitRulesById.put(unitRuleModel.getId(), unitRuleModel);
                for (String up : unitRuleModel.getUp()) {
                    if (unitRulesById.containsKey(up)) continue;
                    unitsToLoad.add(up);
                }
            }
            unitsToLoad.removeAll(bulkIds);
        }
        List notFoundUnits = unitRulesById.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!notFoundUnits.isEmpty()) {
            String unitsToPrint = notFoundUnits.stream().limit(10L).collect(Collectors.joining(",", "[", "]"));
            throw new MetaDataNotFoundException("Could not find " + notFoundUnits.size() + " units: " + unitsToPrint);
        }
        return unitRulesById;
    }

    private List<UnitRuleModel> loadBulkUnitRules(Set<String> unitIds) throws InvalidParseOperationException, MetaDataNotFoundException, MetaDataDocumentSizeException, MetaDataExecutionException, BadRequestException, VitamDBException {
        SelectMultiQuery select = new SelectMultiQuery();
        select.addRoots(unitIds.toArray(new String[0]));
        select.addUsedProjection(new String[]{VitamFieldsHelper.id(), VitamFieldsHelper.unitups(), VitamFieldsHelper.originatingAgency(), VitamFieldsHelper.management()});
        MetadataResult metadataResult = this.metaData.selectUnitsByQuery((JsonNode)select.getFinalSelect());
        ArrayList<UnitRuleModel> unitRules = new ArrayList<UnitRuleModel>();
        for (JsonNode unitRuleJsonNode : metadataResult.getResults()) {
            unitRules.add((UnitRuleModel)JsonHandler.getFromJsonNode((JsonNode)unitRuleJsonNode, UnitRuleModel.class));
        }
        return unitRules;
    }
}

