/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.rules;

import fr.gouv.vitam.common.model.VitamConstants;
import fr.gouv.vitam.common.model.rules.InheritedPropertyResponseModel;
import fr.gouv.vitam.common.model.rules.InheritedRuleCategoryResponseModel;
import fr.gouv.vitam.common.model.rules.InheritedRuleResponseModel;
import fr.gouv.vitam.common.model.rules.UnitInheritedRulesResponseModel;
import fr.gouv.vitam.common.model.rules.UnitRuleModel;
import fr.gouv.vitam.common.model.unit.RuleCategoryModel;
import fr.gouv.vitam.common.model.unit.RuleModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ComputeInheritedRuleService {
    public Map<String, UnitInheritedRulesResponseModel> computeInheritedRules(Map<String, UnitRuleModel> unitRulesById) {
        HashMap<String, UnitInheritedRulesResponseModel> unitInheritedRulesByUnitIdMap = new HashMap<String, UnitInheritedRulesResponseModel>();
        for (String unitId : unitRulesById.keySet()) {
            this.computeUnitInheritedRules(unitId, unitRulesById, unitInheritedRulesByUnitIdMap);
        }
        return unitInheritedRulesByUnitIdMap;
    }

    private void computeUnitInheritedRules(String unitId, Map<String, UnitRuleModel> unitRulesById, Map<String, UnitInheritedRulesResponseModel> unitInheritedRulesByUnitIdMap) {
        if (unitInheritedRulesByUnitIdMap.containsKey(unitId)) {
            return;
        }
        UnitRuleModel unitRuleModel = unitRulesById.get(unitId);
        for (String parentUnit : unitRuleModel.getUp()) {
            this.computeUnitInheritedRules(parentUnit, unitRulesById, unitInheritedRulesByUnitIdMap);
        }
        UnitInheritedRulesResponseModel unitInheritedRules = this.computeUnitInheritedRulesFromParents(unitRuleModel, unitInheritedRulesByUnitIdMap);
        unitInheritedRulesByUnitIdMap.put(unitRuleModel.getId(), unitInheritedRules);
    }

    private UnitInheritedRulesResponseModel computeUnitInheritedRulesFromParents(UnitRuleModel unitRuleModel, Map<String, UnitInheritedRulesResponseModel> unitInheritedRulesByUnitIdMap) {
        UnitInheritedRulesResponseModel unitInheritedRules = new UnitInheritedRulesResponseModel();
        for (String ruleCategory : VitamConstants.getSupportedRules()) {
            InheritedRuleCategoryResponseModel inheritedRuleCategory = this.computeInheritedRuleCategory(unitRuleModel, unitInheritedRulesByUnitIdMap, ruleCategory);
            unitInheritedRules.setRuleCategory(ruleCategory, inheritedRuleCategory);
        }
        List<InheritedPropertyResponseModel> inheritedPropertyResponseModel = this.computeInheritedGlobalProperties(unitRuleModel, unitInheritedRulesByUnitIdMap);
        unitInheritedRules.setGlobalProperties(inheritedPropertyResponseModel);
        return unitInheritedRules;
    }

    private InheritedRuleCategoryResponseModel computeInheritedRuleCategory(UnitRuleModel unitRuleModel, Map<String, UnitInheritedRulesResponseModel> unitInheritedRulesByUnitIdMap, String ruleCategory) {
        RuleCategoryModel ruleCategoryModel = unitRuleModel.getManagementModel().getRuleCategoryModel(ruleCategory);
        List<InheritedRuleResponseModel> rules = this.computeInheritedRules(unitRuleModel, unitInheritedRulesByUnitIdMap, ruleCategory, ruleCategoryModel);
        List<InheritedPropertyResponseModel> properties = this.computeInheritedProperties(unitRuleModel, unitInheritedRulesByUnitIdMap, ruleCategory, ruleCategoryModel);
        return new InheritedRuleCategoryResponseModel(rules, properties);
    }

    private List<InheritedRuleResponseModel> computeInheritedRules(UnitRuleModel unitRuleModel, Map<String, UnitInheritedRulesResponseModel> unitInheritedRulesByUnitIdMap, String ruleCategory, RuleCategoryModel ruleCategoryModel) {
        List<InheritedRuleResponseModel> localRules = this.computeLocalRules(unitRuleModel, ruleCategoryModel);
        List<InheritedRuleResponseModel> inheritedRules = this.getInheritedRules(unitRuleModel, unitInheritedRulesByUnitIdMap, ruleCategory, ruleCategoryModel);
        return ListUtils.union(localRules, inheritedRules);
    }

    private List<InheritedRuleResponseModel> computeLocalRules(UnitRuleModel unitRuleModel, RuleCategoryModel ruleCategoryModel) {
        if (ruleCategoryModel == null) {
            return Collections.emptyList();
        }
        return ruleCategoryModel.getRules().stream().map(ruleModel -> new InheritedRuleResponseModel(unitRuleModel.getId(), unitRuleModel.getOriginatingAgency(), Collections.singletonList(Collections.singletonList(unitRuleModel.getId())), ruleModel.getRule(), ruleModel.getRuleAttributes())).collect(Collectors.toList());
    }

    private List<InheritedRuleResponseModel> getInheritedRules(UnitRuleModel unitRuleModel, Map<String, UnitInheritedRulesResponseModel> unitInheritedRulesByUnitIdMap, String ruleCategory, RuleCategoryModel ruleCategoryModel) {
        if (ruleCategoryModel != null && ruleCategoryModel.isPreventInheritance()) {
            return Collections.emptyList();
        }
        HashSet filteredRuleIds = new HashSet();
        if (ruleCategoryModel != null) {
            if (ruleCategoryModel.getRules() != null) {
                ruleCategoryModel.getRules().stream().map(RuleModel::getRule).forEach(filteredRuleIds::add);
            }
            if (ruleCategoryModel.getInheritance() != null && ruleCategoryModel.getInheritance().getPreventRulesId() != null) {
                filteredRuleIds.addAll(ruleCategoryModel.getInheritance().getPreventRulesId());
            }
        }
        ArrayList<InheritedRuleResponseModel> inheritedRulesFromParents = new ArrayList<InheritedRuleResponseModel>();
        for (String parentUnitId : unitRuleModel.getUp()) {
            InheritedRuleCategoryResponseModel parentUnitInheritedRuleCategory = (InheritedRuleCategoryResponseModel)unitInheritedRulesByUnitIdMap.get(parentUnitId).getRuleCategories().get(ruleCategory);
            parentUnitInheritedRuleCategory.getRules().stream().filter(rule -> !filteredRuleIds.contains(rule.getRuleId())).forEach(rule -> inheritedRulesFromParents.add(new InheritedRuleResponseModel(rule.getUnitId(), rule.getOriginatingAgency(), this.prependPaths(rule.getPaths(), unitRuleModel.getId()), rule.getRuleId(), rule.getExtendedRuleAttributes())));
        }
        return this.mergeInheritedRulesFromParents(inheritedRulesFromParents);
    }

    private List<List<String>> prependPaths(List<List<String>> paths, String unitId) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (List<String> path : paths) {
            ArrayList<String> newPath = new ArrayList<String>(path.size() + 1);
            newPath.add(unitId);
            newPath.addAll(path);
            result.add(newPath);
        }
        return result;
    }

    private List<InheritedRuleResponseModel> mergeInheritedRulesFromParents(List<InheritedRuleResponseModel> inheritedRulesFromParents) {
        Map<Pair, List<InheritedRuleResponseModel>> inheritedRulesByUnitIdAndRuleId = inheritedRulesFromParents.stream().collect(Collectors.groupingBy(rule -> Pair.of((Object)rule.getUnitId(), (Object)rule.getRuleId())));
        ArrayList<InheritedRuleResponseModel> result = new ArrayList<InheritedRuleResponseModel>();
        for (List<InheritedRuleResponseModel> inheritedRulesToMerge : inheritedRulesByUnitIdAndRuleId.values()) {
            InheritedRuleResponseModel inheritedRule;
            InheritedRuleResponseModel firstInheritedRule = inheritedRulesToMerge.get(0);
            if (inheritedRulesToMerge.size() == 1) {
                inheritedRule = firstInheritedRule;
            } else {
                List mergedPaths = inheritedRulesToMerge.stream().flatMap(r -> r.getPaths().stream()).collect(Collectors.toList());
                inheritedRule = new InheritedRuleResponseModel(firstInheritedRule.getUnitId(), firstInheritedRule.getOriginatingAgency(), mergedPaths, firstInheritedRule.getRuleId(), firstInheritedRule.getExtendedRuleAttributes());
            }
            result.add(inheritedRule);
        }
        return result;
    }

    private List<InheritedPropertyResponseModel> computeInheritedProperties(UnitRuleModel unitRuleModel, Map<String, UnitInheritedRulesResponseModel> unitInheritedRulesByUnitIdMap, String ruleCategory, RuleCategoryModel ruleCategoryModel) {
        List<InheritedPropertyResponseModel> localProperties = this.computeLocalProperties(unitRuleModel, ruleCategoryModel);
        List<InheritedPropertyResponseModel> inheritedProperties = this.getInheritedProperties(unitRuleModel, unitInheritedRulesByUnitIdMap, ruleCategory, ruleCategoryModel);
        List explicitlyDeclaredProperties = ListUtils.union(localProperties, inheritedProperties);
        List<InheritedPropertyResponseModel> implicitProperties = this.computeImplicitProperties(ruleCategory, unitRuleModel, explicitlyDeclaredProperties);
        Set implicitPropertyNames = implicitProperties.stream().map(InheritedPropertyResponseModel::getPropertyName).collect(Collectors.toSet());
        return ListUtils.union(implicitProperties, explicitlyDeclaredProperties.stream().filter(p -> !implicitPropertyNames.contains(p.getPropertyName())).collect(Collectors.toList()));
    }

    private List<InheritedPropertyResponseModel> computeLocalProperties(UnitRuleModel unitRuleModel, RuleCategoryModel ruleCategoryModel) {
        if (ruleCategoryModel == null) {
            return Collections.emptyList();
        }
        return ruleCategoryModel.getProperties().entrySet().stream().map(property -> new InheritedPropertyResponseModel(unitRuleModel.getId(), unitRuleModel.getOriginatingAgency(), Collections.singletonList(Collections.singletonList(unitRuleModel.getId())), (String)property.getKey(), property.getValue())).collect(Collectors.toList());
    }

    private List<InheritedPropertyResponseModel> getInheritedProperties(UnitRuleModel unitRuleModel, Map<String, UnitInheritedRulesResponseModel> unitInheritedRulesByUnitIdMap, String ruleCategory, RuleCategoryModel ruleCategoryModel) {
        if (ruleCategoryModel != null && ruleCategoryModel.isPreventInheritance()) {
            return Collections.emptyList();
        }
        HashSet filteredProperties = new HashSet();
        if (ruleCategoryModel != null && ruleCategoryModel.getProperties() != null) {
            filteredProperties.addAll(ruleCategoryModel.getProperties().keySet());
        }
        ArrayList<InheritedPropertyResponseModel> inheritedPropertiesFromParents = new ArrayList<InheritedPropertyResponseModel>();
        for (String parentUnitId : unitRuleModel.getUp()) {
            InheritedRuleCategoryResponseModel parentUnitInheritedRuleCategory = (InheritedRuleCategoryResponseModel)unitInheritedRulesByUnitIdMap.get(parentUnitId).getRuleCategories().get(ruleCategory);
            parentUnitInheritedRuleCategory.getProperties().stream().filter(property -> !filteredProperties.contains(property.getPropertyName())).forEach(property -> inheritedPropertiesFromParents.add(new InheritedPropertyResponseModel(property.getUnitId(), property.getOriginatingAgency(), this.prependPaths(property.getPaths(), unitRuleModel.getId()), property.getPropertyName(), property.getPropertyValue())));
        }
        return this.mergeInheritedPropertiesFromParents(inheritedPropertiesFromParents);
    }

    private List<InheritedPropertyResponseModel> mergeInheritedPropertiesFromParents(List<InheritedPropertyResponseModel> inheritedPropertiesFromParents) {
        Map<Pair, List<InheritedPropertyResponseModel>> inheritedPropertiesByUnitIdAndPropertyName = inheritedPropertiesFromParents.stream().collect(Collectors.groupingBy(property -> Pair.of((Object)property.getUnitId(), (Object)property.getPropertyName())));
        ArrayList<InheritedPropertyResponseModel> result = new ArrayList<InheritedPropertyResponseModel>();
        for (List<InheritedPropertyResponseModel> inheritedPropertiesToMerge : inheritedPropertiesByUnitIdAndPropertyName.values()) {
            InheritedPropertyResponseModel inheritedProperty;
            InheritedPropertyResponseModel firstInheritedProperty = inheritedPropertiesToMerge.get(0);
            if (inheritedPropertiesToMerge.size() == 1) {
                inheritedProperty = firstInheritedProperty;
            } else {
                List mergedPaths = inheritedPropertiesToMerge.stream().flatMap(r -> r.getPaths().stream()).collect(Collectors.toList());
                inheritedProperty = new InheritedPropertyResponseModel(firstInheritedProperty.getUnitId(), firstInheritedProperty.getOriginatingAgency(), mergedPaths, firstInheritedProperty.getPropertyName(), firstInheritedProperty.getPropertyValue());
            }
            result.add(inheritedProperty);
        }
        return result;
    }

    private List<InheritedPropertyResponseModel> computeImplicitProperties(String ruleCategory, UnitRuleModel unitRuleModel, List<InheritedPropertyResponseModel> explicitlyDeclaredProperties) {
        boolean isHoldingUnit;
        boolean bl = isHoldingUnit = unitRuleModel.getOriginatingAgency() == null;
        if (isHoldingUnit) {
            return Collections.emptyList();
        }
        Set explicitlyDefinedPropertyNames = explicitlyDeclaredProperties.stream().filter(p -> unitRuleModel.getOriginatingAgency().equals(p.getOriginatingAgency())).map(InheritedPropertyResponseModel::getPropertyName).collect(Collectors.toSet());
        if (ruleCategory.equals("AppraisalRule") && !explicitlyDefinedPropertyNames.contains("FinalAction")) {
            return Collections.singletonList(new InheritedPropertyResponseModel(unitRuleModel.getId(), unitRuleModel.getOriginatingAgency(), Collections.singletonList(Collections.singletonList(unitRuleModel.getId())), "FinalAction", (Object)VitamConstants.AppraisalRuleFinalAction.KEEP.value()));
        }
        return Collections.emptyList();
    }

    private List<InheritedPropertyResponseModel> computeInheritedGlobalProperties(UnitRuleModel unitRuleModel, Map<String, UnitInheritedRulesResponseModel> unitInheritedRulesByUnitIdMap) {
        HashMap<String, Object> globalProperties = new HashMap<String, Object>();
        if (unitRuleModel.getManagementModel().isNeedAuthorization() != null) {
            globalProperties.put("NeedAuthorization", unitRuleModel.getManagementModel().isNeedAuthorization());
        }
        List<InheritedPropertyResponseModel> localProperties = this.computeLocalGlobalProperties(unitRuleModel, globalProperties);
        List<InheritedPropertyResponseModel> inheritedProperties = this.getInheritedGlobalProperties(unitRuleModel, unitInheritedRulesByUnitIdMap, globalProperties);
        return ListUtils.union(localProperties, inheritedProperties);
    }

    private List<InheritedPropertyResponseModel> computeLocalGlobalProperties(UnitRuleModel unitRuleModel, Map<String, Object> globalProperties) {
        if (globalProperties == null) {
            return Collections.emptyList();
        }
        return globalProperties.entrySet().stream().map(globalProperty -> new InheritedPropertyResponseModel(unitRuleModel.getId(), unitRuleModel.getOriginatingAgency(), Collections.singletonList(Collections.singletonList(unitRuleModel.getId())), (String)globalProperty.getKey(), globalProperty.getValue())).collect(Collectors.toList());
    }

    private List<InheritedPropertyResponseModel> getInheritedGlobalProperties(UnitRuleModel unitRuleModel, Map<String, UnitInheritedRulesResponseModel> unitInheritedRulesByUnitIdMap, Map<String, Object> globalProperties) {
        HashSet<String> filteredProperties = new HashSet<String>();
        if (globalProperties != null && globalProperties.get("NeedAuthorization") != null) {
            filteredProperties.addAll(globalProperties.keySet());
        }
        ArrayList<InheritedPropertyResponseModel> inheritedPropertiesFromParents = new ArrayList<InheritedPropertyResponseModel>();
        for (String parentUnitId : unitRuleModel.getUp()) {
            List parentUnitInheritedGlobalProperties = unitInheritedRulesByUnitIdMap.get(parentUnitId).getGlobalProperties();
            parentUnitInheritedGlobalProperties.stream().filter(property -> !filteredProperties.contains(property.getPropertyName())).forEach(property -> inheritedPropertiesFromParents.add(new InheritedPropertyResponseModel(property.getUnitId(), property.getOriginatingAgency(), this.prependPaths(property.getPaths(), unitRuleModel.getId()), property.getPropertyName(), property.getPropertyValue())));
        }
        return this.mergeInheritedPropertiesFromParents(inheritedPropertiesFromParents);
    }
}

