/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.reconstruction.service;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.accesslog.AccessLogUtils;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.stream.VitamAsyncInputStream;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.metadata.core.database.collections.MetadataCollections;
import fr.gouv.vitam.metadata.core.reconstruction.model.MetadataBackupModel;
import fr.gouv.vitam.storage.engine.client.OfferLogHelper;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageUnavailableDataFromAsyncOfferClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.model.Order;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;

public class RestoreBackupService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(RestoreBackupService.class);
    private StorageClientFactory storageClientFactory;

    public RestoreBackupService() {
        this(StorageClientFactory.getInstance());
    }

    @VisibleForTesting
    public RestoreBackupService(StorageClientFactory storageClientFactory) {
        this.storageClientFactory = storageClientFactory;
    }

    public Iterator<OfferLog> getListing(String strategy, String offerId, DataCategory category, Long offset, Integer limit, Order order, int batchSize) throws StorageServerClientException, StorageNotFoundClientException {
        LOGGER.info(String.format("[Reconstruction]: Retrieve listing of {%s} Collection on {%s} Vitam strategy from {%s} offset with {%s} limit", category, strategy, offset, limit));
        return OfferLogHelper.getListing((StorageClientFactory)this.storageClientFactory, (String)strategy, (String)offerId, (DataCategory)category, (Long)offset, (Order)order, (int)batchSize, (Integer)limit);
    }

    /*
     * Loose catch block
     */
    public MetadataBackupModel loadData(String strategy, String referentOffer, MetadataCollections collection, String filename, long offset) {
        MetadataBackupModel metadataBackupModel;
        InputStream inputStream = null;
        try {
            DataCategory type;
            switch (collection) {
                case UNIT: {
                    type = DataCategory.UNIT;
                    break;
                }
                case OBJECTGROUP: {
                    type = DataCategory.OBJECTGROUP;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("ERROR: Invalid collection {%s}", new Object[]{collection}));
                }
            }
            inputStream = this.loadData(strategy, referentOffer, type, filename);
            MetadataBackupModel metadataBackupModel2 = (MetadataBackupModel)JsonHandler.getFromInputStream((InputStream)inputStream, MetadataBackupModel.class);
            if (metadataBackupModel2.getMetadata() == null || metadataBackupModel2.getLifecycle() == null) {
                LOGGER.error("Invalid data model: " + JsonHandler.unprettyPrint((Object)metadataBackupModel2));
                throw new VitamRuntimeException("Invalid data to reconstruct.");
            }
            metadataBackupModel2.setOffset(offset);
            metadataBackupModel = metadataBackupModel2;
        }
        catch (StorageNotFoundException ex) {
            LOGGER.warn(String.format("[Reconstruction]: Could not find file {%s} for the collection {%s} on the tenant {%s}. Corrupted file (atomicity bug) OR eliminated? ", new Object[]{filename, collection, VitamThreadUtils.getVitamSession().getTenantId()}));
            MetadataBackupModel metadataBackupModel3 = null;
            IOUtils.closeQuietly((InputStream)inputStream);
            return metadataBackupModel3;
        }
        catch (InvalidParseOperationException e) {
            throw new VitamRuntimeException("An exception has been thrown when using storage service:", (Throwable)e);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return metadataBackupModel;
    }

    public InputStream loadData(String strategy, String referentOffer, DataCategory category, String filename) throws StorageNotFoundException {
        VitamAsyncInputStream vitamAsyncInputStream;
        block9: {
            LOGGER.info(String.format("[Reconstruction]: Retrieve file {%s} from storage of {%s} Collection on {%s} Vitam strategy", filename, category.name(), strategy));
            StorageClient storageClient = this.storageClientFactory.getClient();
            try {
                vitamAsyncInputStream = new VitamAsyncInputStream(storageClient.getContainerAsync(strategy, referentOffer, filename, category, AccessLogUtils.getNoLogAccessLog()));
                if (storageClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (storageClient != null) {
                        try {
                            storageClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StorageNotFoundException e) {
                    throw e;
                }
                catch (StorageServerClientException | StorageUnavailableDataFromAsyncOfferClientException | StorageException e) {
                    throw new VitamRuntimeException("ERROR: Exception has been thrown when using storage service:", e);
                }
            }
            storageClient.close();
        }
        return vitamAsyncInputStream;
    }
}

