/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.reconstruction.service;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.ExecutorUtils;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.metadata.api.model.PersistentIdentifierReconstructionRequest;
import fr.gouv.vitam.metadata.core.config.MetaDataConfiguration;
import fr.gouv.vitam.metadata.core.reconstruction.domain.OffsetManager;
import fr.gouv.vitam.metadata.core.reconstruction.domain.PersistentIdentifierReconstructionManager;
import fr.gouv.vitam.metadata.core.reconstruction.repository.ReconstructionResponse;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;

public class PersistentIdentifierReconstructionService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PersistentIdentifierReconstructionService.class);
    private final OffsetManager offsetManager;
    private final PersistentIdentifierReconstructionManager persistentIdentifierReconstructionManager;
    private final int persistentIdentifierReconstructionThreadPoolSize;
    private final long persistentIdentifierReconstructionDelayInMinutes;

    public PersistentIdentifierReconstructionService(OffsetManager offsetManager, PersistentIdentifierReconstructionManager persistentIdentifierReconstructionManager, MetaDataConfiguration metaDataConfiguration) {
        this.offsetManager = offsetManager;
        this.persistentIdentifierReconstructionManager = persistentIdentifierReconstructionManager;
        this.persistentIdentifierReconstructionThreadPoolSize = metaDataConfiguration.getPersistentIdentifierReconstructionThreadPoolSize();
        this.persistentIdentifierReconstructionDelayInMinutes = metaDataConfiguration.getPersistentIdentifierReconstructionDelayInMinutes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReconstructionResponse reconstruct(PersistentIdentifierReconstructionRequest request) {
        String requestId = VitamThreadUtils.getVitamSession().getRequestId();
        List tenantList = ParametersChecker.checkNullOrEmptyParameters((String)"List of tenants cannot be null and must contain at least one element", (List)request.getTenants());
        ExecutorService executorService = this.createExecutorService(Math.min(this.persistentIdentifierReconstructionThreadPoolSize, tenantList.size()));
        ArrayList<CompletableFuture<Void>> completableFutures = new ArrayList<CompletableFuture<Void>>();
        try {
            ReconstructionResponse globalResponse = new ReconstructionResponse.Builder().status(ReconstructionResponse.ReconstructionStatus.INIT).build();
            for (Integer tenant : tenantList) {
                CompletableFuture<Void> reconstructionFuture = CompletableFuture.runAsync(() -> {
                    try {
                        this.configureThreadAndSession(tenant, requestId);
                        LocalDateTime startDate = this.offsetManager.retrieveLastReconstructionDateFromOffset(tenant);
                        LocalDateTime endDate = this.offsetManager.retrieveEndDateWithDelay(this.persistentIdentifierReconstructionDelayInMinutes);
                        LOGGER.info("Start of reconstruction between dates {} and {} for tenant {}", new Object[]{startDate, endDate, tenant});
                        ReconstructionResponse response = this.persistentIdentifierReconstructionManager.reconstruct(startDate, endDate);
                        this.offsetManager.saveNextReconstructionDateInOffset(tenant, response.getLastSuccessfulOperationDate());
                        LOGGER.info("End of reconstruction between dates {} and {} for tenant {}", new Object[]{startDate, endDate, tenant});
                        LOGGER.info("Date of the last operation processed in the persistent identifier reconstruction : {} for tenant {}", (Object)response.getLastSuccessfulOperationDate(), (Object)tenant);
                        globalResponse.accumulate(response);
                    }
                    catch (Exception e) {
                        LOGGER.error("An error occurred during persistent identifier reconstruction for tenant " + tenant, (Throwable)e);
                        globalResponse.accumulate(new ReconstructionResponse.Builder().status(ReconstructionResponse.ReconstructionStatus.FAILURE).build());
                    }
                }, executorService);
                completableFutures.add(reconstructionFuture);
            }
            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).join();
            ReconstructionResponse reconstructionResponse = globalResponse;
            return reconstructionResponse;
        }
        catch (Exception e) {
            LOGGER.error("An error occurred during persistent identifier reconstruction", (Throwable)e);
            ReconstructionResponse reconstructionResponse = new ReconstructionResponse.Builder().status(ReconstructionResponse.ReconstructionStatus.FAILURE).build();
            return reconstructionResponse;
        }
        finally {
            executorService.shutdown();
        }
    }

    private ExecutorService createExecutorService(int threadPoolSize) {
        return ExecutorUtils.createScalableBatchExecutorService((int)threadPoolSize);
    }

    private void configureThreadAndSession(int tenant, String requestId) {
        Thread.currentThread().setName("PersistentIdentifierReconstruction-" + tenant);
        VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(tenant));
        VitamThreadUtils.getVitamSession().setRequestId(requestId);
    }
}

