/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.reconstruction.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import fr.gouv.vitam.common.CommonMediaType;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.api.VitamRepositoryProvider;
import fr.gouv.vitam.common.database.offset.OffsetRepository;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.database.utils.MetadataDocumentHelper;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamFatalRuntimeException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.metrics.VitamCommonMetrics;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.storage.compress.VitamArchiveStreamFactory;
import fr.gouv.vitam.common.thread.ExecutorUtils;
import fr.gouv.vitam.common.thread.NamedVitamThreadFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.metadata.api.model.ReconstructionRequestItem;
import fr.gouv.vitam.metadata.api.model.ReconstructionResponseItem;
import fr.gouv.vitam.metadata.core.config.ElasticsearchMetadataIndexManager;
import fr.gouv.vitam.metadata.core.config.MetaDataConfiguration;
import fr.gouv.vitam.metadata.core.database.collections.MetadataCollections;
import fr.gouv.vitam.metadata.core.graph.StoreGraphService;
import fr.gouv.vitam.metadata.core.metrics.MetadataReconstructionMetrics;
import fr.gouv.vitam.metadata.core.metrics.MetadataReconstructionMetricsCache;
import fr.gouv.vitam.metadata.core.reconstruction.exception.ReconstructionException;
import fr.gouv.vitam.metadata.core.reconstruction.model.MetadataBackupModel;
import fr.gouv.vitam.metadata.core.reconstruction.service.RestoreBackupService;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.model.Order;
import fr.gouv.vitam.storage.engine.common.referential.model.OfferReference;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageStrategy;
import fr.gouv.vitam.storage.engine.common.utils.StorageStrategyUtils;
import io.prometheus.client.Histogram;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MetadataReconstructionService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MetadataReconstructionService.class);
    private static final String RECONSTRUCTION_ITEM_MANDATORY_MSG = "the item defining reconstruction is mandatory.";
    private static final String RECONSTRUCTION_COLLECTION_MANDATORY_MSG = "the collection to reconstruct is mandatory.";
    private static final String RECONSTRUCTION_TENANT_MANDATORY_MSG = "the tenant to reconstruct is mandatory.";
    private static final String RECONSTRUCTION_LIMIT_POSITIVE_MSG = "the limit to reconstruct is should at least 0.";
    private static final String $_SET = "$set";
    private static final String EV_DATE_TIME = "evDateTime";
    private final LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory;
    private final StorageClientFactory storageClientFactory;
    private final VitamRepositoryProvider vitamRepositoryProvider;
    private final OffsetRepository offsetRepository;
    private final ElasticsearchMetadataIndexManager indexManager;
    private final RestoreBackupService restoreBackupService;
    private final MetadataReconstructionMetricsCache reconstructionMetricsCache;
    private final int reconstructionPoolSize;
    private final int reconstructionBatchSize;
    private final int reconstructionBatchLoadingTimeoutInSeconds;

    public MetadataReconstructionService(VitamRepositoryProvider vitamRepositoryProvider, OffsetRepository offsetRepository, ElasticsearchMetadataIndexManager indexManager, MetadataReconstructionMetricsCache reconstructionMetricsCache, MetaDataConfiguration metadataConfiguration) {
        this(vitamRepositoryProvider, new RestoreBackupService(), LogbookLifeCyclesClientFactory.getInstance(), StorageClientFactory.getInstance(), offsetRepository, indexManager, reconstructionMetricsCache, metadataConfiguration.getReconstructionPoolSize(), metadataConfiguration.getReconstructionBatchSize(), metadataConfiguration.getReconstructionBatchLoadingTimeoutInSeconds());
    }

    @VisibleForTesting
    public MetadataReconstructionService(VitamRepositoryProvider vitamRepositoryProvider, RestoreBackupService recoverBackupService, LogbookLifeCyclesClientFactory logbookLifecycleClientFactory, StorageClientFactory storageClientFactory, OffsetRepository offsetRepository, ElasticsearchMetadataIndexManager indexManager, MetadataReconstructionMetricsCache reconstructionMetricsCache, int reconstructionPoolSize, int reconstructionBatchSize, int reconstructionBatchLoadingTimeoutInSeconds) {
        this.vitamRepositoryProvider = vitamRepositoryProvider;
        this.restoreBackupService = recoverBackupService;
        this.logbookLifeCyclesClientFactory = logbookLifecycleClientFactory;
        this.storageClientFactory = storageClientFactory;
        this.offsetRepository = offsetRepository;
        this.indexManager = indexManager;
        this.reconstructionMetricsCache = reconstructionMetricsCache;
        this.reconstructionPoolSize = reconstructionPoolSize;
        this.reconstructionBatchSize = reconstructionBatchSize;
        this.reconstructionBatchLoadingTimeoutInSeconds = reconstructionBatchLoadingTimeoutInSeconds;
    }

    public ReconstructionResponseItem reconstruct(ReconstructionRequestItem reconstructionItem) {
        ParametersChecker.checkParameter((String)RECONSTRUCTION_ITEM_MANDATORY_MSG, (Object[])new Object[]{reconstructionItem});
        ParametersChecker.checkParameter((String)RECONSTRUCTION_COLLECTION_MANDATORY_MSG, (String[])new String[]{reconstructionItem.getCollection()});
        ParametersChecker.checkParameter((String)RECONSTRUCTION_TENANT_MANDATORY_MSG, (Object[])new Object[]{reconstructionItem.getTenant()});
        if (reconstructionItem.getLimit() < 0) {
            throw new IllegalArgumentException(RECONSTRUCTION_LIMIT_POSITIVE_MSG);
        }
        LOGGER.info(String.format("[Reconstruction]: Reconstruction of {%s} Collection on {%s} Vitam tenant", reconstructionItem.getCollection(), reconstructionItem.getTenant()));
        DataCategory dataCategory = DataCategory.valueOf((String)reconstructionItem.getCollection().toUpperCase());
        switch (dataCategory) {
            case UNIT_GRAPH: 
            case OBJECTGROUP_GRAPH: {
                Integer tenant = VitamConfiguration.getAdminTenant();
                return this.applyAndCollectionMetrics(dataCategory.name(), tenant, () -> this.reconstructGraphFromZipStream(dataCategory, tenant, reconstructionItem.getLimit()));
            }
            case UNIT: 
            case OBJECTGROUP: {
                MetadataCollections metadataCollections = MetadataCollections.getFromValue(reconstructionItem.getCollection());
                return this.applyAndCollectionMetrics(metadataCollections.name(), reconstructionItem.getTenant(), () -> this.reconstructCollection(metadataCollections, reconstructionItem.getTenant(), reconstructionItem.getLimit()));
            }
        }
        return new ReconstructionResponseItem(reconstructionItem, StatusCode.KO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReconstructionResponseItem applyAndCollectionMetrics(String collectionName, Integer tenant, Supplier<ReconstructionResponseItem> responseItemSupplier) {
        Histogram.Timer timer = ((Histogram.Child)VitamCommonMetrics.RECONSTRUCTION_DURATION.labels(new String[]{String.valueOf(tenant), collectionName})).startTimer();
        try {
            ReconstructionResponseItem reconstructionResponseItem = responseItemSupplier.get();
            return reconstructionResponseItem;
        }
        finally {
            timer.observeDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReconstructionResponseItem reconstructGraphFromZipStream(DataCategory dataCategory, Integer tenant, int limit) {
        MetadataCollections metaDaCollection;
        ParametersChecker.checkParameter((String)"Parameter dataCategory is required.", (Object[])new Object[]{dataCategory});
        VitamThreadUtils.getVitamSession().setTenantId(tenant);
        long lastReconstructedOffset = this.offsetRepository.findOffsetBy(tenant.intValue(), VitamConfiguration.getDefaultStrategy(), dataCategory.name());
        long startOffset = lastReconstructedOffset + 1L;
        LOGGER.info(String.format("[Reconstruction]: Start reconstruction of the {%s} collection on the Vitam tenant {%s} for %s elements starting from {%s}.", dataCategory.name(), tenant, limit, startOffset));
        ReconstructionResponseItem response = new ReconstructionResponseItem().setCollection(dataCategory.name()).setTenant(tenant);
        switch (dataCategory) {
            case UNIT_GRAPH: {
                metaDaCollection = MetadataCollections.UNIT;
                break;
            }
            case OBJECTGROUP_GRAPH: {
                metaDaCollection = MetadataCollections.OBJECTGROUP;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("ERROR: Invalid collection {%s}", dataCategory.name()));
            }
        }
        try {
            LocalDateTime reconstructionStartDateTime = LocalDateUtil.now();
            String referentOffer = this.storageClientFactory.getClient().getReferentOffer(VitamConfiguration.getDefaultStrategy());
            Iterator<OfferLog> listing = this.restoreBackupService.getListing(VitamConfiguration.getDefaultStrategy(), referentOffer, dataCategory, startOffset, limit, Order.ASC, this.reconstructionBatchSize);
            boolean isEmpty = true;
            while (listing.hasNext()) {
                isEmpty = false;
                OfferLog offerLog = listing.next();
                this.reconstructionMetricsCache.registerLastGraphReconstructionDate(metaDaCollection, StoreGraphService.parseGraphStartDateFromFileName(offerLog.getFileName()));
                String guid = GUIDFactory.newGUID().getId();
                Path filePath = Files.createTempFile(guid + "_", offerLog.getFileName(), new FileAttribute[0]);
                try {
                    try (InputStream zipFileAsStream = this.restoreBackupService.loadData(VitamConfiguration.getDefaultStrategy(), referentOffer, dataCategory, offerLog.getFileName());){
                        Files.copy(zipFileAsStream, filePath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (StorageNotFoundException ex) {
                        throw new ReconstructionException("Could not find graph zip file " + offerLog.getFileName(), ex);
                    }
                    try (InputStream zipInputStream = Files.newInputStream(filePath, new OpenOption[0]);){
                        this.reconstructGraphFromZipStream(metaDaCollection, zipInputStream);
                    }
                }
                finally {
                    Files.deleteIfExists(filePath);
                }
                long lastOffset = offerLog.getSequence();
                this.offsetRepository.createOrUpdateOffset(tenant.intValue(), VitamConfiguration.getDefaultStrategy(), dataCategory.name(), lastOffset);
                LOGGER.info(String.format("[Reconstruction]: the collection {%s} has been reconstructed on the tenant {%s} from {offset:%s} at %s", dataCategory.name(), tenant, lastOffset, LocalDateUtil.now()));
                this.reconstructionMetricsCache.registerLastGraphReconstructionDate(metaDaCollection, StoreGraphService.parseGraphEndDateFromFileName(offerLog.getFileName()));
            }
            if (isEmpty) {
                this.reconstructionMetricsCache.registerLastGraphReconstructionDate(metaDaCollection, reconstructionStartDateTime);
            }
            response.setStatus(StatusCode.OK);
        }
        catch (ReconstructionException | IOException e) {
            LOGGER.error(String.format("[Reconstruction]: Exception has been thrown when reconstructing Vitam collection {%s} metadata on the tenant {%s} from {offset:%s}", dataCategory.name(), tenant, startOffset), (Throwable)e);
            response.setStatus(StatusCode.KO);
        }
        catch (StorageNotFoundClientException | StorageServerClientException e) {
            LOGGER.error(e.getMessage());
            response.setStatus(StatusCode.KO);
        }
        return response;
    }

    private ReconstructionResponseItem reconstructCollection(MetadataCollections collection, int tenant, int limit) {
        LOGGER.info(String.format("[Reconstruction]: Start reconstruction of the {%s} collection on the Vitam tenant {%s} for %s elements.", collection.name(), tenant, limit));
        ReconstructionResponseItem response = new ReconstructionResponseItem().setCollection(collection.name()).setTenant(Integer.valueOf(tenant)).setStatus(StatusCode.OK);
        List<String> strategies = this.loadStrategies();
        MetadataReconstructionMetrics.initialize(strategies, this.reconstructionMetricsCache);
        for (String strategy : strategies) {
            String referentOffer;
            StatusCode currentStatusCode = this.reconstructCollection(collection, tenant, strategy, referentOffer = this.getReferentOffer(strategy), limit);
            if (currentStatusCode.getStatusLevel() <= response.getStatus().getStatusLevel()) continue;
            response.setStatus(currentStatusCode);
        }
        return response;
    }

    private List<String> loadStrategies() {
        Integer originalTenant = VitamThreadUtils.getVitamSession().getTenantId();
        try {
            List<String> list;
            block13: {
                StorageClient storageClient = this.storageClientFactory.getClient();
                try {
                    VitamThreadUtils.getVitamSession().setTenantId(VitamConfiguration.getAdminTenant());
                    RequestResponse strategiesResponse = storageClient.getStorageStrategies();
                    if (!strategiesResponse.isOk()) {
                        LOGGER.error(strategiesResponse.toString());
                        throw new StorageException("Exception while retrieving storage strategies");
                    }
                    List storageStrategies = ((RequestResponseOK)strategiesResponse).getResults().stream().filter(s -> s.getOffers().stream().filter(OfferReference::isReferent).filter(OfferReference::isEnabled).count() == 1L).collect(Collectors.toList());
                    if (!StorageStrategyUtils.checkReferentOfferUsageInStrategiesValid(storageStrategies)) {
                        LOGGER.warn("One or more offers are referents in more than one strategy. As a consequence the reconstruction for these referent offers is executed as many times as they are declared in a strategy");
                    }
                    list = storageStrategies.stream().map(StorageStrategy::getId).collect(Collectors.toList());
                    if (storageClient == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (storageClient != null) {
                            try {
                                storageClient.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (StorageClientException | StorageException e) {
                        throw new VitamRuntimeException(e);
                    }
                }
                storageClient.close();
            }
            return list;
        }
        finally {
            VitamThreadUtils.getVitamSession().setTenantId(originalTenant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatusCode reconstructCollection(MetadataCollections collection, int tenant, String strategy, String referentOffer, int limit) {
        long lastReconstructedOffset = this.offsetRepository.findOffsetBy(tenant, strategy, collection.getName());
        long startOffset = lastReconstructedOffset + 1L;
        LOGGER.info(String.format("[Reconstruction]: Start reconstruction of the {%s} collection for the strategy {%s} on the Vitam tenant {%s} for %s elements starting from {%s}.", collection.name(), strategy, tenant, limit, startOffset));
        Integer originalTenant = VitamThreadUtils.getVitamSession().getTenantId();
        try {
            DataCategory type;
            VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(tenant));
            switch (collection) {
                case UNIT: {
                    type = DataCategory.UNIT;
                    break;
                }
                case OBJECTGROUP: {
                    type = DataCategory.OBJECTGROUP;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("ERROR: Invalid collection {%s}", new Object[]{collection}));
                }
            }
            LocalDateTime reconstructionStartDateTime = LocalDateUtil.now();
            LocalDateTime lastReconstructedDocumentDate = null;
            int nbEntriesReconstructed = 0;
            Iterator<OfferLog> listing = this.restoreBackupService.getListing(strategy, referentOffer, type, startOffset, limit, Order.ASC, this.reconstructionBatchSize);
            UnmodifiableIterator bulkListing = Iterators.partition(listing, (int)this.reconstructionBatchSize);
            Long newOffset = null;
            while (bulkListing.hasNext()) {
                List listingBulk = (List)bulkListing.next();
                ArrayList<OfferLog> writtenMetadata = new ArrayList<OfferLog>();
                ArrayList<String> deletedMetadataIds = new ArrayList<String>();
                block16: for (OfferLog offerLog : listingBulk) {
                    switch (offerLog.getAction()) {
                        case WRITE: {
                            writtenMetadata.add(offerLog);
                            continue block16;
                        }
                        case DELETE: {
                            deletedMetadataIds.add(this.metadataFilenameToGuid(offerLog.getFileName()));
                            continue block16;
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported offer log action " + offerLog.getAction());
                }
                this.processWrittenMetadata(collection, strategy, referentOffer, writtenMetadata);
                this.processDeletedMetadata(collection, deletedMetadataIds);
                newOffset = ((OfferLog)Iterables.getLast((Iterable)listingBulk)).getSequence();
                nbEntriesReconstructed += listingBulk.size();
                lastReconstructedDocumentDate = ((OfferLog)listingBulk.get(listingBulk.size() - 1)).getTime();
                LOGGER.debug(String.format("[Reconstruction]: the collection {%s} has been reconstructed for the strategy {%s} on the tenant {%s} to {offset:%s} at %s", collection.name(), strategy, tenant, newOffset, LocalDateUtil.now()));
            }
            if (newOffset == null) {
                LOGGER.info(String.format("[Reconstruction]: No new data to reconstruct for collection {%s} / strategy {%s} / tenant {%s} from {offset:%s} at %s", collection.name(), strategy, tenant, startOffset, LocalDateUtil.now()));
            } else {
                this.offsetRepository.createOrUpdateOffset(tenant, strategy, collection.getName(), newOffset.longValue());
                LOGGER.info(String.format("[Reconstruction]: the collection {%s} has been reconstructed for the strategy {%s} on the tenant {%s} to {offset:%s} at %s", collection.name(), strategy, tenant, newOffset, LocalDateUtil.now()));
            }
            if (nbEntriesReconstructed != limit) {
                lastReconstructedDocumentDate = LocalDateUtil.max((LocalDateTime)reconstructionStartDateTime, lastReconstructedDocumentDate);
            }
            this.reconstructionMetricsCache.registerLastDocumentReconstructionDate(collection, tenant, strategy, lastReconstructedDocumentDate);
            StatusCode statusCode = StatusCode.OK;
            return statusCode;
        }
        catch (DatabaseException | InvalidParseOperationException | LogbookClientException | StorageException e) {
            LOGGER.error(String.format("[Reconstruction]: Exception has been thrown when reconstructing Vitam collection {%s} metadata & lifecycles for the strategy {%s} on the tenant {%s} from {offset:%s}", new Object[]{collection, strategy, tenant, startOffset}), e);
            StatusCode statusCode = StatusCode.KO;
            return statusCode;
        }
        catch (StorageNotFoundClientException | StorageServerClientException e) {
            LOGGER.error("Error occured when getting data from Storage : " + e.getMessage(), e);
            StatusCode statusCode = StatusCode.KO;
            return statusCode;
        }
        finally {
            VitamThreadUtils.getVitamSession().setTenantId(originalTenant);
        }
    }

    private void processWrittenMetadata(MetadataCollections collection, String strategy, String referentOffer, List<OfferLog> writtenMetadata) throws StorageException, DatabaseException, LogbookClientException, InvalidParseOperationException {
        if (writtenMetadata.isEmpty()) {
            return;
        }
        for (int retry = VitamConfiguration.getOptimisticLockRetryNumber(); retry > 0; --retry) {
            List<MetadataBackupModel> dataFromOffer = this.loadMetadataSet(collection, strategy, referentOffer, writtenMetadata);
            if (dataFromOffer.isEmpty()) {
                return;
            }
            try {
                this.reconstructCollectionMetadata(collection, dataFromOffer);
                this.reconstructCollectionLifecycles(collection, dataFromOffer);
                return;
            }
            catch (DatabaseException e) {
                if (!(e.getCause() instanceof MongoBulkWriteException)) {
                    throw e;
                }
                LOGGER.warn("[Reconstruction]: [Optimistic_Lock]: optimistic lock occurs while reconstruct AU/GOT");
                try {
                    Thread.sleep(ThreadLocalRandom.current().nextInt(VitamConfiguration.getOptimisticLockSleepTime()));
                    continue;
                }
                catch (InterruptedException e1) {
                    SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e1);
                    Thread.currentThread().interrupt();
                    throw new DatabaseException((Throwable)e1);
                }
            }
        }
        throw new DatabaseException("Optimistic lock number of retry reached");
    }

    private List<MetadataBackupModel> loadMetadataSet(MetadataCollections collection, String strategy, String referentOffer, List<OfferLog> writtenMetadata) throws StorageException {
        ThreadPoolExecutor executor = ExecutorUtils.createScalableBatchExecutorService((int)Math.min(this.reconstructionPoolSize, writtenMetadata.size()), (ThreadFactory)new NamedVitamThreadFactory(MetadataReconstructionService.class.getSimpleName()));
        try {
            ArrayList<CompletableFuture<MetadataBackupModel>> completableFutures = new ArrayList<CompletableFuture<MetadataBackupModel>>();
            for (OfferLog offerLog : writtenMetadata) {
                completableFutures.add(CompletableFuture.supplyAsync(() -> this.restoreBackupService.loadData(strategy, referentOffer, collection, offerLog.getFileName(), offerLog.getSequence()), executor));
            }
            CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get(this.reconstructionBatchLoadingTimeoutInSeconds, TimeUnit.SECONDS);
            List list = completableFutures.stream().map(CompletableFuture::join).filter(Objects::nonNull).collect(Collectors.toList());
            return list;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new StorageException("Cannot load metadata from storage. Interrupted thread", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new StorageException("Cannot load metadata from storage. Timeout", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new StorageException("Cannot load metadata from storage", (Throwable)e);
        }
        finally {
            executor.shutdown();
        }
    }

    private void processDeletedMetadata(MetadataCollections collection, List<String> deletedMetadataIds) throws DatabaseException, LogbookClientBadRequestException, LogbookClientServerException {
        if (deletedMetadataIds.isEmpty()) {
            return;
        }
        this.reconstructDeletedMetadata(collection, deletedMetadataIds);
        this.reconstructDeletedLifecycles(collection, deletedMetadataIds);
    }

    private String metadataFilenameToGuid(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf(46));
    }

    private void reconstructDeletedMetadata(MetadataCollections collection, List<String> ids) throws DatabaseException {
        LOGGER.info("[Reconstruction]: delete metadata bulk");
        int tenant = VitamThreadUtils.getVitamSession().getTenantId();
        this.vitamRepositoryProvider.getVitamMongoRepository(collection.getVitamCollection()).delete(ids, tenant);
        this.vitamRepositoryProvider.getVitamESRepository(collection.getVitamCollection(), this.indexManager.getElasticsearchIndexAliasResolver(collection)).delete(ids, tenant);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void reconstructDeletedLifecycles(MetadataCollections collection, List<String> ids) throws LogbookClientBadRequestException, LogbookClientServerException {
        LOGGER.info("[Reconstruction]: delete lifecycle bulk");
        try (LogbookLifeCyclesClient logbookLifecycleClient = this.logbookLifeCyclesClientFactory.getClient();){
            switch (collection) {
                case UNIT: {
                    logbookLifecycleClient.deleteLifecycleUnitsBulk(ids);
                    return;
                }
                case OBJECTGROUP: {
                    logbookLifecycleClient.deleteLifecycleObjectGroupBulk(ids);
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Invalid collection");
                }
            }
        }
    }

    private void preventAlreadyExistingGraphData(MetadataCollections collection, List<MetadataBackupModel> dataFromOffer) {
        Bson projection;
        String id;
        ArrayList<MetadataBackupModel> toRemove = new ArrayList<MetadataBackupModel>();
        HashMap<String, MetadataBackupModel> dataMap = new HashMap<String, MetadataBackupModel>();
        for (MetadataBackupModel mbm : dataFromOffer) {
            Document document = mbm.getMetadata();
            id = document.getString((Object)"_id");
            MetadataBackupModel alreadyExists = (MetadataBackupModel)dataMap.remove(id);
            if (null != alreadyExists) {
                toRemove.add(alreadyExists);
            }
            dataMap.put(id, mbm);
        }
        dataFromOffer.removeAll(toRemove);
        switch (collection) {
            case UNIT: {
                projection = Projections.include((List)MetadataDocumentHelper.getComputedGraphUnitFields());
                break;
            }
            case OBJECTGROUP: {
                projection = Projections.include((List)MetadataDocumentHelper.getComputedGraphObjectGroupFields());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported metadata type " + collection);
            }
        }
        try (MongoCursor iterator = this.vitamRepositoryProvider.getVitamMongoRepository(collection.getVitamCollection()).findDocuments(dataMap.keySet(), projection).iterator();){
            while (iterator.hasNext()) {
                Document sourceDocument = (Document)iterator.next();
                id = sourceDocument.getString((Object)"_id");
                Document targetDocument = ((MetadataBackupModel)dataMap.get(id)).getMetadata();
                targetDocument.putAll((Map)sourceDocument);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void reconstructCollectionLifecycles(MetadataCollections collection, List<MetadataBackupModel> bulk) throws LogbookClientException, InvalidParseOperationException {
        LOGGER.info("[Reconstruction]: Back up of lifecycles bulk");
        try (LogbookLifeCyclesClient logbookLifecycleClient = this.logbookLifeCyclesClientFactory.getClient();){
            List lifecycles = bulk.stream().map(model -> {
                try {
                    if (model.getLifecycle() != null) {
                        return BsonHelper.fromDocumentToJsonNode((Document)model.getLifecycle());
                    }
                    throw new VitamRuntimeException("lifecycle should not be null");
                }
                catch (InvalidParseOperationException e) {
                    throw new VitamRuntimeException((Throwable)e);
                }
            }).collect(Collectors.toList());
            switch (collection) {
                case UNIT: {
                    logbookLifecycleClient.createRawbulkUnitlifecycles(lifecycles);
                    return;
                }
                case OBJECTGROUP: {
                    logbookLifecycleClient.createRawbulkObjectgrouplifecycles(lifecycles);
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Invalid collection");
                }
            }
        }
        catch (VitamRuntimeException lifecycleParsingException) {
            throw new InvalidParseOperationException((Throwable)lifecycleParsingException);
        }
    }

    private void reconstructCollectionMetadata(MetadataCollections collection, List<MetadataBackupModel> dataFromOffer) throws DatabaseException {
        LOGGER.info("[Reconstruction]: Back up of metadata bulk");
        this.preventAlreadyExistingGraphData(collection, dataFromOffer);
        List<Document> documents = dataFromOffer.stream().map(this::addComputedMetadata).map(MetadataBackupModel::getMetadata).collect(Collectors.toList());
        List<WriteModel<Document>> metadata = documents.stream().map(this::createReplaceOneModel).collect(Collectors.toList());
        this.bulkMongo(collection, metadata);
        this.bulkElasticSearch(collection, documents);
    }

    private MetadataBackupModel addComputedMetadata(MetadataBackupModel backupModel) {
        List events = ((List)Objects.requireNonNullElse(backupModel.getLifecycle().getList((Object)"events", Map.class), new ArrayList())).stream().map(map -> (Map)map).collect(Collectors.toList());
        if (!events.isEmpty()) {
            Map lastEvent = (Map)events.get(events.size() - 1);
            String approximateDateTime = this.reformatEventDateTime((String)lastEvent.get(EV_DATE_TIME));
            backupModel.getMetadata().put("_acd", (Object)this.reformatEventDateTime(backupModel.getLifecycle().getString((Object)EV_DATE_TIME)));
            backupModel.getMetadata().put("_aud", (Object)approximateDateTime);
        }
        return backupModel;
    }

    private String reformatEventDateTime(String persistedEvDateTime) {
        return LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)LocalDateUtil.parseMongoFormattedDate((String)persistedEvDateTime));
    }

    private void reconstructGraphFromZipStream(MetadataCollections metaDaCollection, InputStream zipStream) throws ReconstructionException {
        LOGGER.info("[Reconstruction]: Back up of metadata bulk");
        try (ArchiveInputStream archiveInputStream = new VitamArchiveStreamFactory().createArchiveInputStream(CommonMediaType.valueOf((String)"application/zip"), zipStream);){
            ArchiveEntry entry;
            while ((entry = archiveInputStream.getNextEntry()) != null) {
                if (!archiveInputStream.canReadEntryData(entry) || entry.isDirectory()) continue;
                ArrayNode arrayNode = (ArrayNode)JsonHandler.getFromInputStream((InputStream)CloseShieldInputStream.wrap((InputStream)archiveInputStream));
                this.treatBulkGraph(metaDaCollection, arrayNode);
            }
        }
        catch (DatabaseException | InvalidParseOperationException | IOException | ArchiveException e) {
            throw new ReconstructionException(e);
        }
    }

    private void treatBulkGraph(MetadataCollections metadataCollections, ArrayNode arrayNode) throws DatabaseException {
        ArrayList<WriteModel<Document>> collection = new ArrayList<WriteModel<Document>>();
        HashSet<String> ids = new HashSet<String>();
        arrayNode.forEach(o -> {
            try {
                ids.add(o.get("_id").asText());
                collection.add((WriteModel<Document>)this.createUpdateOneModel((JsonNode)o));
            }
            catch (InvalidParseOperationException e) {
                throw new VitamFatalRuntimeException((Throwable)e);
            }
        });
        this.bulkMongo(metadataCollections, collection);
        this.bulkElasticSearch(metadataCollections, ids);
    }

    private void bulkMongo(MetadataCollections metaDaCollection, List<WriteModel<Document>> collection) throws DatabaseException {
        this.vitamRepositoryProvider.getVitamMongoRepository(metaDaCollection.getVitamCollection()).update(collection);
    }

    private void bulkElasticSearch(MetadataCollections metaDaCollection, Set<String> ids) throws DatabaseException {
        if (ids.isEmpty()) {
            return;
        }
        Bson query = Filters.and((Bson[])new Bson[]{Filters.exists((String)"_tenant", (boolean)true), Filters.in((String)"_id", ids)});
        FindIterable fit = this.vitamRepositoryProvider.getVitamMongoRepository(metaDaCollection.getVitamCollection()).findDocuments(query, VitamConfiguration.getBatchSize());
        MongoCursor it = fit.iterator();
        ArrayList<Document> documents = new ArrayList<Document>();
        while (it.hasNext()) {
            documents.add((Document)it.next());
        }
        this.bulkElasticSearch(metaDaCollection, documents);
    }

    private void bulkElasticSearch(MetadataCollections metaDaCollection, List<Document> collection) throws DatabaseException {
        this.vitamRepositoryProvider.getVitamESRepository(metaDaCollection.getVitamCollection(), this.indexManager.getElasticsearchIndexAliasResolver(metaDaCollection)).save(collection);
    }

    private UpdateOneModel<Document> createUpdateOneModel(JsonNode graphData) throws InvalidParseOperationException {
        JsonNode id = ((ObjectNode)graphData).remove("_id");
        Document data = new Document($_SET, (Object)Document.parse((String)JsonHandler.writeAsString((Object)graphData)));
        return new UpdateOneModel(Filters.eq((String)"_id", (Object)id.asText()), (Bson)data, new UpdateOptions().upsert(true));
    }

    private WriteModel<Document> createReplaceOneModel(Document document) {
        Object glpd = document.get((Object)"_glpd");
        Bson filter = null == glpd ? Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)document.get((Object)"_id")), Filters.exists((String)"_glpd", (boolean)false)}) : Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)document.get((Object)"_id")), Filters.eq((String)"_glpd", (Object)glpd.toString())});
        return new ReplaceOneModel(filter, (Object)document, new ReplaceOptions().upsert(true));
    }

    public void purgeReconstructedDocumentsWithGraphOnlyData(MetadataCollections metaDaCollection) {
        try {
            String dateDeleteLimit = LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)LocalDateUtil.now().minus(VitamConfiguration.getDeleteIncompleteReconstructedUnitDelay(), ChronoUnit.SECONDS));
            Bson query = Filters.and((Bson[])new Bson[]{Filters.exists((String)"_tenant", (boolean)false), Filters.lte((String)"_glpd", (Object)dateDeleteLimit)});
            this.vitamRepositoryProvider.getVitamMongoRepository(metaDaCollection.getVitamCollection()).remove(query);
        }
        catch (DatabaseException e) {
            LOGGER.error("[Reconstruction]: Error while remove older documents having only graph data", (Throwable)e);
        }
    }

    private String getReferentOffer(String strategy) {
        String string;
        block8: {
            StorageClient storageClient = this.storageClientFactory.getClient();
            try {
                string = storageClient.getReferentOffer(strategy);
                if (storageClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (storageClient != null) {
                        try {
                            storageClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StorageNotFoundClientException | StorageServerClientException e) {
                    throw new VitamRuntimeException("ERROR: Cannot retrieve referent offer", e);
                }
            }
            storageClient.close();
        }
        return string;
    }
}

