/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.reconstruction.repository.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.database.builder.query.InQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.RangeQuery;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.logbook.LogbookOperation;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.core.reconstruction.exception.ReconstructionException;
import fr.gouv.vitam.metadata.core.reconstruction.model.ReconstructionOperation;
import fr.gouv.vitam.metadata.core.reconstruction.repository.ReconstructionOperationRepository;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ReconstructionOperationRepositoryImpl
implements ReconstructionOperationRepository {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ReconstructionOperationRepository.class);
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;

    public ReconstructionOperationRepositoryImpl() {
        this(LogbookOperationsClientFactory.getInstance());
    }

    public ReconstructionOperationRepositoryImpl(LogbookOperationsClientFactory logbookOperationsClientFactory) {
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
    }

    @Override
    public List<ReconstructionOperation> fetchReconstructionOperations(LocalDateTime startDate, LocalDateTime endDate) throws ReconstructionException {
        List<ReconstructionOperation> list;
        block8: {
            LogbookOperationsClient client = this.logbookOperationsClientFactory.getClient();
            try {
                JsonNode queryDsl = this.getDslForSelectOperation(startDate, endDate);
                JsonNode result = client.selectOperation(queryDsl, false, false);
                RequestResponseOK requestResponse = RequestResponseOK.getFromJsonNode((JsonNode)result);
                List logbookOperations = JsonHandler.getFromJsonNodeList((List)requestResponse.getResults(), (TypeReference)new TypeReference<LogbookOperation>(){});
                list = logbookOperations.stream().map(logbookOperation -> ReconstructionOperation.builder().setId(logbookOperation.getId()).setTenant(logbookOperation.getTenant()).setType(logbookOperation.getEvType()).setLastPersistedDate(Optional.ofNullable(logbookOperation.getLastPersistentDate()).orElse("")).build()).collect(Collectors.toList());
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | LogbookClientException e) {
                    throw new ReconstructionException("Error fetching reconstruction operations", e);
                }
            }
            client.close();
        }
        return list;
    }

    JsonNode getDslForSelectOperation(LocalDateTime startDate, LocalDateTime endDate) {
        Select select = new Select();
        try {
            Date from = LocalDateUtil.getDate((LocalDateTime)startDate);
            Date to = LocalDateUtil.getDate((LocalDateTime)endDate);
            RangeQuery range = QueryHelper.range((String)VitamFieldsHelper.lastPersistedDate(), (Date)from, (boolean)true, (Date)to, (boolean)false);
            String[] evTypes = new String[]{"ELIMINATION_ACTION", "DELETE_GOT_VERSIONS", "TRANSFER_REPLY"};
            InQuery type = QueryHelper.in((String)"evType", (String[])evTypes);
            String[] operationOutDetails = new String[]{"ELIMINATION_ACTION.OK", "ELIMINATION_ACTION.WARNING", "DELETE_GOT_VERSIONS.OK", "TRANSFER_REPLY.OK"};
            InQuery status = QueryHelper.in((String)"events.outDetail", (String[])operationOutDetails);
            select.setLimitFilter(0L, 10000L);
            select.addOrderByAscFilter(new String[]{VitamFieldsHelper.lastPersistedDate()});
            select.setQuery((Query)QueryHelper.and().add(new Query[]{range, type, status}));
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            throw new IllegalStateException("Error when generate DSL for get Operations", e);
        }
        return select.getFinalSelect();
    }
}

