/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.reconstruction.repository.impl;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.accesslog.AccessLogUtils;
import fr.gouv.vitam.metadata.core.reconstruction.exception.ReconstructionException;
import fr.gouv.vitam.metadata.core.reconstruction.repository.OperationReportRepository;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageUnavailableDataFromAsyncOfferClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import java.io.InputStream;
import javax.ws.rs.core.Response;

public class OperationReportRepositoryImpl
implements OperationReportRepository {
    public static final String JSONL = ".jsonl";
    private final StorageClientFactory storageClientFactory;

    public OperationReportRepositoryImpl() {
        this(StorageClientFactory.getInstance());
    }

    public OperationReportRepositoryImpl(StorageClientFactory storageClientFactory) {
        this.storageClientFactory = storageClientFactory;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream retrieveJsonReportForOperation(String operationId) throws ReconstructionException {
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            InputStream inputStream;
            block14: {
                Response reportResponse = storageClient.getContainerAsync(VitamConfiguration.getDefaultStrategy(), operationId + JSONL, DataCategory.REPORT, AccessLogUtils.getNoLogAccessLog());
                try {
                    inputStream = (InputStream)reportResponse.readEntity(InputStream.class);
                    if (reportResponse == null) break block14;
                }
                catch (Throwable throwable) {
                    if (reportResponse != null) {
                        try {
                            reportResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reportResponse.close();
            }
            return inputStream;
        }
        catch (StorageServerClientException | StorageUnavailableDataFromAsyncOfferClientException | StorageNotFoundException e) {
            throw new ReconstructionException("Error retrieving JsonReport for operation" + operationId, e);
        }
    }
}

