/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.reconstruction.repository;

import java.time.LocalDateTime;

public class ReconstructionResponse {
    public ReconstructionStatus status;
    private LocalDateTime lastSuccessfulOperationDate;

    private ReconstructionResponse() {
    }

    public boolean isFailure() {
        return this.status == ReconstructionStatus.FAILURE;
    }

    public boolean isSuccess() {
        return this.status == ReconstructionStatus.SUCCESS;
    }

    public boolean isInit() {
        return this.status == ReconstructionStatus.INIT;
    }

    public synchronized void accumulate(ReconstructionResponse response) {
        this.status = (this.isSuccess() || this.isInit()) && response.isSuccess() ? ReconstructionStatus.SUCCESS : ReconstructionStatus.FAILURE;
    }

    public LocalDateTime getLastSuccessfulOperationDate() {
        return this.lastSuccessfulOperationDate;
    }

    public static class Builder {
        private ReconstructionResponse response = new ReconstructionResponse();

        public Builder status(ReconstructionStatus status) {
            this.response.status = status;
            return this;
        }

        public Builder lastSuccessfulOperationDate(LocalDateTime lastSuccessfulOperationDate) {
            this.response.lastSuccessfulOperationDate = lastSuccessfulOperationDate;
            return this;
        }

        public ReconstructionResponse build() {
            return this.response;
        }
    }

    public static enum ReconstructionStatus {
        INIT,
        SUCCESS,
        FAILURE;

    }
}

