/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.reconstruction.model;

import com.mongodb.BasicDBList;
import fr.gouv.vitam.common.database.server.mongodb.BsonHelper;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.unit.PersistentIdentifierModel;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;

public class PurgedPersistentIdentifier {
    private final String id;
    private final Integer tenant;
    private final List<PersistentIdentifierModel> persistentIdentifiers;
    private final Integer version;
    private final String type;
    private final String operationId;
    private final String operationType;
    private final String operationLastPersistentDate;
    private final String objectGroupId;
    private final String archivalAgencyIdentifier;
    private final String lastPersistentDate;

    private PurgedPersistentIdentifier(Builder builder) {
        this.id = builder.id;
        this.tenant = builder.tenant;
        this.persistentIdentifiers = builder.persistentIdentifiers;
        this.version = builder.version;
        this.type = builder.type;
        this.objectGroupId = builder.objectGroupId;
        this.archivalAgencyIdentifier = builder.archivalAgencyIdentifier;
        this.operationId = builder.operationId;
        this.operationType = builder.operationType;
        this.operationLastPersistentDate = builder.operationLastPersistentDate;
        this.lastPersistentDate = builder.lastPersistentDate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Document toDocument(PurgedPersistentIdentifier purgedIdentifier) {
        Document document = new Document();
        document.append("_id", (Object)purgedIdentifier.getId());
        document.append("persistentIdentifier", (Object)PurgedPersistentIdentifier.convertPersistentIdentifierModelListToDocuments(purgedIdentifier.getPersistentIdentifier()));
        document.append("_tenant", (Object)purgedIdentifier.getTenant());
        document.append("_v", (Object)0);
        document.append("type", (Object)purgedIdentifier.getType());
        document.append("idObjectGroup", (Object)purgedIdentifier.getObjectGroupId());
        document.append("archivalAgencyIdentifier", (Object)purgedIdentifier.getArchivalAgencyIdentifier());
        document.append("opId", (Object)purgedIdentifier.getOperationId());
        document.append("opType", (Object)purgedIdentifier.getOperationType());
        document.append("opEndDate", (Object)purgedIdentifier.getOperationLastPersistentDate());
        return document;
    }

    public static PurgedPersistentIdentifier fromDocument(Document document) throws InvalidParseOperationException {
        ArrayList<PersistentIdentifierModel> persistentIdentifierModels = new ArrayList<PersistentIdentifierModel>();
        List persistentIdentifiersAsDocuments = document.getList((Object)"persistentIdentifier", Document.class);
        for (Document persistentIdentifier : persistentIdentifiersAsDocuments) {
            persistentIdentifierModels.add((PersistentIdentifierModel)BsonHelper.fromDocumentToObject((Document)persistentIdentifier, PersistentIdentifierModel.class));
        }
        return PurgedPersistentIdentifier.builder().setId(document.getString((Object)"_id")).setTenant(document.getInteger((Object)"_tenant")).setVersion(document.getInteger((Object)"_v")).setType(document.getString((Object)"type")).setObjectGroupId(document.getString((Object)"idObjectGroup")).setArchivalAgencyIdentifier(document.getString((Object)"archivalAgencyIdentifier")).setOperationId(document.getString((Object)"opId")).setOperationType(document.getString((Object)"opType")).setOperationLastPersistentDate(document.getString((Object)"opEndDate")).setLastPersistentDate(document.getString((Object)"lastPersistentDate")).setPersistentIdentifier(persistentIdentifierModels).build();
    }

    public static List<Document> convertListToDocumentList(List<PurgedPersistentIdentifier> purgedIdentifierList) {
        ArrayList<Document> documentList = new ArrayList<Document>();
        for (PurgedPersistentIdentifier purgedIdentifier : purgedIdentifierList) {
            Document document = PurgedPersistentIdentifier.toDocument(purgedIdentifier);
            documentList.add(document);
        }
        return documentList;
    }

    private static BasicDBList convertPersistentIdentifierModelListToDocuments(List<PersistentIdentifierModel> persistentIdentifierModels) {
        BasicDBList bsonArray = new BasicDBList();
        for (PersistentIdentifierModel persistentIdentifierModel : persistentIdentifierModels) {
            bsonArray.add((Object)Document.parse((String)JsonHandler.unprettyPrint((Object)persistentIdentifierModel)));
        }
        return bsonArray;
    }

    public String getId() {
        return this.id;
    }

    public Integer getTenant() {
        return this.tenant;
    }

    public List<PersistentIdentifierModel> getPersistentIdentifier() {
        return this.persistentIdentifiers;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public String getObjectGroupId() {
        return this.objectGroupId;
    }

    public String getArchivalAgencyIdentifier() {
        return this.archivalAgencyIdentifier;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public String getOperationLastPersistentDate() {
        return this.operationLastPersistentDate;
    }

    public String getLastPersistentDate() {
        return this.lastPersistentDate;
    }

    public static class Builder {
        private String id;
        private Integer tenant;
        private List<PersistentIdentifierModel> persistentIdentifiers;
        private Integer version;
        private String type;
        private String objectGroupId;
        private String operationId;
        private String operationType;
        private String operationLastPersistentDate;
        private String archivalAgencyIdentifier;
        public String lastPersistentDate;

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setTenant(Integer tenant) {
            this.tenant = tenant;
            return this;
        }

        public Builder setPersistentIdentifier(List<PersistentIdentifierModel> persistentIdentifiers) {
            this.persistentIdentifiers = persistentIdentifiers;
            return this;
        }

        public Builder setVersion(Integer version) {
            this.version = version;
            return this;
        }

        public Builder setObjectGroupId(String objectGroupId) {
            this.objectGroupId = objectGroupId;
            return this;
        }

        public Builder setArchivalAgencyIdentifier(String archivalAgencyIdentifier) {
            this.archivalAgencyIdentifier = archivalAgencyIdentifier;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setLastPersistentDate(String lastPersistentDate) {
            this.lastPersistentDate = lastPersistentDate;
            return this;
        }

        public Builder setOperationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public Builder setOperationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        public Builder setOperationLastPersistentDate(String operationLastPersistentDate) {
            this.operationLastPersistentDate = operationLastPersistentDate;
            return this;
        }

        public PurgedPersistentIdentifier build() {
            return new PurgedPersistentIdentifier(this);
        }
    }
}

