/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.reconstruction.domain.extractor;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.metadata.core.reconstruction.domain.PurgedPersistentIdentifierValidator;
import fr.gouv.vitam.metadata.core.reconstruction.domain.extractor.PurgedPersistentIdentifierExtractor;
import fr.gouv.vitam.metadata.core.reconstruction.model.PurgedPersistentIdentifier;
import fr.gouv.vitam.metadata.core.reconstruction.model.ReconstructionOperation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class VersionPurgedPersistentIdentifierExtractor
extends PurgedPersistentIdentifierExtractor {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(VersionPurgedPersistentIdentifierExtractor.class);

    @Override
    public List<PurgedPersistentIdentifier> extractPurgedPersistentIdentifier(JsonNode jsonNode, ReconstructionOperation operation) {
        String objectGroupId = jsonNode.get("objectGroupId").asText();
        return Optional.ofNullable(jsonNode).map(node -> node.path("objectGroupGlobal")).filter(JsonNode::isArray).map(objectGroupNodes -> StreamSupport.stream(objectGroupNodes.spliterator(), false).map(objectGroupNode -> StreamSupport.stream(objectGroupNode.path("deletedVersions").spliterator(), false).map(deletedVersionNode -> this.buildObjetPurgedPersistentIdentifier(objectGroupId, (JsonNode)deletedVersionNode, operation)).filter(Objects::nonNull).collect(Collectors.toList())).collect(Collectors.toList())).orElse(Collections.emptyList()).stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public PurgedPersistentIdentifier buildObjetPurgedPersistentIdentifier(String objectGroupId, JsonNode element, ReconstructionOperation operation) {
        if (!PurgedPersistentIdentifierValidator.validateFields(element, "id", "persistentIdentifier")) {
            LOGGER.warn("This element {} is ignored in the persistent identifier reconstruction because id or persistent identifier are not provided", (Object)element);
            return null;
        }
        return PurgedPersistentIdentifier.builder().setId(element.get("id").asText()).setTenant(operation.getTenant()).setPersistentIdentifier(this.extractPersistentIdentifiers(element.get("persistentIdentifier"))).setVersion(0).setType("Object").setObjectGroupId(objectGroupId).setOperationId(operation.getId()).setOperationType(operation.getType()).setOperationLastPersistentDate(operation.getLastPersistedDate()).build();
    }
}

