/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.reconstruction.domain.extractor;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.unit.PersistentIdentifierModel;
import fr.gouv.vitam.metadata.core.reconstruction.domain.PurgedPersistentIdentifierValidator;
import fr.gouv.vitam.metadata.core.reconstruction.domain.extractor.PurgedPersistentIdentifierExtractor;
import fr.gouv.vitam.metadata.core.reconstruction.model.PurgedPersistentIdentifier;
import fr.gouv.vitam.metadata.core.reconstruction.model.ReconstructionOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class UnitPurgedPersistentIdentifierExtractor
extends PurgedPersistentIdentifierExtractor {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(UnitPurgedPersistentIdentifierExtractor.class);

    @Override
    public List<PurgedPersistentIdentifier> extractPurgedPersistentIdentifier(JsonNode node, ReconstructionOperation operation) {
        PurgedPersistentIdentifier purgedPersistentIdentifier;
        List<PersistentIdentifierModel> persistentIdentifierModels;
        ArrayList<PurgedPersistentIdentifier> purgedPersistentIdentifiers = new ArrayList<PurgedPersistentIdentifier>();
        JsonNode persistentIdentifierNode = node.get("persistentIdentifier");
        if (persistentIdentifierNode != null && !persistentIdentifierNode.isNull() && (persistentIdentifierModels = this.extractPersistentIdentifiers(persistentIdentifierNode)) != null && !persistentIdentifierModels.isEmpty() && (purgedPersistentIdentifier = this.buildUnitPurgedPersistentIdentifier(node, operation)) != null) {
            purgedPersistentIdentifiers.add(purgedPersistentIdentifier);
        }
        return purgedPersistentIdentifiers;
    }

    public PurgedPersistentIdentifier buildUnitPurgedPersistentIdentifier(JsonNode element, ReconstructionOperation operation) {
        if (!PurgedPersistentIdentifierValidator.validateFields(element, "id", "persistentIdentifier")) {
            LOGGER.warn("This element {} is ignored in the persistent identifier reconstruction because id or persistent identifier are not provided", (Object)element);
            return null;
        }
        return PurgedPersistentIdentifier.builder().setId(element.get("id").asText()).setTenant(operation.getTenant()).setPersistentIdentifier(this.extractPersistentIdentifiers(element.get("persistentIdentifier"))).setVersion(0).setType("Unit").setObjectGroupId(null).setArchivalAgencyIdentifier(Optional.ofNullable(element.get("archivalAgencyIdentifier")).map(JsonNode::asText).orElse(null)).setOperationId(operation.getId()).setOperationType(operation.getType()).setOperationLastPersistentDate(operation.getLastPersistedDate()).build();
    }
}

