/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.reconstruction.domain.extractor;

import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.core.reconstruction.domain.extractor.ObjectPurgedPersistentIdentifierExtractor;
import fr.gouv.vitam.metadata.core.reconstruction.domain.extractor.PurgedPersistentIdentifierExtractor;
import fr.gouv.vitam.metadata.core.reconstruction.domain.extractor.UnitPurgedPersistentIdentifierExtractor;
import fr.gouv.vitam.metadata.core.reconstruction.domain.extractor.VersionPurgedPersistentIdentifierExtractor;
import fr.gouv.vitam.metadata.core.reconstruction.model.ReportLine;

public class PurgedPersistentIdentifierExtractorFactory {
    private static PurgedPersistentIdentifierExtractor unitInstance;
    private static PurgedPersistentIdentifierExtractor objectGroupInstance;
    private static PurgedPersistentIdentifierExtractor versionInstance;

    public PurgedPersistentIdentifierExtractor instance(ReportLine.ReportLineType type) throws MetaDataExecutionException {
        switch (type) {
            case DELETED_UNIT: 
            case TRANSFERRED_UNIT: {
                if (unitInstance == null) {
                    unitInstance = new UnitPurgedPersistentIdentifierExtractor();
                }
                return unitInstance;
            }
            case DELETED_OBJECT_GROUP: 
            case TRANSFERRED_OBJECT_GROUP: {
                if (objectGroupInstance == null) {
                    objectGroupInstance = new ObjectPurgedPersistentIdentifierExtractor();
                }
                return objectGroupInstance;
            }
            case DELETED_GOT_VERSION: {
                if (versionInstance == null) {
                    versionInstance = new VersionPurgedPersistentIdentifierExtractor();
                }
                return versionInstance;
            }
        }
        throw new MetaDataExecutionException("Illegal reconstruction type parameter '" + type + "'");
    }
}

