/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.reconstruction.domain.extractor;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.metadata.core.reconstruction.domain.PurgedPersistentIdentifierValidator;
import fr.gouv.vitam.metadata.core.reconstruction.domain.extractor.PurgedPersistentIdentifierExtractor;
import fr.gouv.vitam.metadata.core.reconstruction.model.PurgedPersistentIdentifier;
import fr.gouv.vitam.metadata.core.reconstruction.model.ReconstructionOperation;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class ObjectPurgedPersistentIdentifierExtractor
extends PurgedPersistentIdentifierExtractor {
    public static final String OBJECT = "Object";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ObjectPurgedPersistentIdentifierExtractor.class);

    @Override
    public List<PurgedPersistentIdentifier> extractPurgedPersistentIdentifier(JsonNode node, ReconstructionOperation operation) {
        String objectGroupId = node.get("id").asText();
        return Optional.ofNullable(node.get("objectVersions")).filter(JsonNode::isArray).map(objectVersions -> StreamSupport.stream(objectVersions.spliterator(), false).filter(objectVersion -> objectVersion.has("persistentIdentifier") && !objectVersion.get("persistentIdentifier").isNull()).map(objectVersion -> this.buildObjetPurgedPersistentIdentifier(objectGroupId, (JsonNode)objectVersion, operation)).filter(Objects::nonNull).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public PurgedPersistentIdentifier buildObjetPurgedPersistentIdentifier(String objectGroupId, JsonNode element, ReconstructionOperation operation) {
        if (!PurgedPersistentIdentifierValidator.validateFields(element, "id", "persistentIdentifier")) {
            LOGGER.warn("This element {} is ignored in the persistent identifier reconstruction because id or persistent identifier are not provided", (Object)element);
            return null;
        }
        return PurgedPersistentIdentifier.builder().setId(element.get("id").asText()).setTenant(operation.getTenant()).setPersistentIdentifier(this.extractPersistentIdentifiers(element.get("persistentIdentifier"))).setVersion(0).setType(OBJECT).setObjectGroupId(objectGroupId).setArchivalAgencyIdentifier(Optional.ofNullable(element.get("archivalAgencyIdentifier")).map(JsonNode::asText).orElse(null)).setOperationId(operation.getId()).setOperationType(operation.getType()).setOperationLastPersistentDate(operation.getLastPersistedDate()).build();
    }
}

