/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.reconstruction.domain;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.metadata.core.reconstruction.domain.ArrayFieldValidator;
import fr.gouv.vitam.metadata.core.reconstruction.domain.FieldValidator;
import fr.gouv.vitam.metadata.core.reconstruction.domain.SimpleFieldValidator;
import fr.gouv.vitam.metadata.core.reconstruction.domain.StringFieldValidator;

public class PurgedPersistentIdentifierValidator {
    public static boolean validateFields(JsonNode element, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            if (PurgedPersistentIdentifierValidator.validateField(element, fieldName)) continue;
            return false;
        }
        return true;
    }

    private static boolean validateField(JsonNode element, String fieldName) {
        JsonNode fieldNode = element.get(fieldName);
        if (fieldNode == null) {
            return false;
        }
        FieldValidator validator = PurgedPersistentIdentifierValidator.getValidator(fieldNode);
        return validator != null && validator.validate(fieldNode);
    }

    private static FieldValidator getValidator(JsonNode fieldNode) {
        if (fieldNode.isTextual()) {
            return new StringFieldValidator();
        }
        if (fieldNode.isArray()) {
            return new ArrayFieldValidator();
        }
        return new SimpleFieldValidator();
    }
}

