/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.reconstruction.domain;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.core.config.MetaDataConfiguration;
import fr.gouv.vitam.metadata.core.reconstruction.model.PurgedPersistentIdentifier;
import fr.gouv.vitam.metadata.core.reconstruction.repository.PersistentIdentifierRepository;
import java.util.ArrayList;
import java.util.List;

public class PurgedPersistentIdentifierBulkInserter {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PurgedPersistentIdentifierBulkInserter.class);
    private final Integer bulkSize;
    private final PersistentIdentifierRepository persistentIdentifierRepository;
    private List<PurgedPersistentIdentifier> purgedPersistentIdentifiers = new ArrayList<PurgedPersistentIdentifier>();

    public PurgedPersistentIdentifierBulkInserter(MetaDataConfiguration metaDataConfiguration, PersistentIdentifierRepository persistentIdentifierRepository) {
        this.bulkSize = metaDataConfiguration.getPersistentIdentifierReconstructionBulkSize();
        this.persistentIdentifierRepository = persistentIdentifierRepository;
    }

    public void append(PurgedPersistentIdentifier purgedPersistentIdentifier) throws MetaDataExecutionException {
        if (this.purgedPersistentIdentifiers.size() >= this.bulkSize) {
            this.persistentIdentifierRepository.insert(PurgedPersistentIdentifier.convertListToDocumentList(this.purgedPersistentIdentifiers));
            this.purgedPersistentIdentifiers.clear();
        } else {
            this.purgedPersistentIdentifiers.add(purgedPersistentIdentifier);
        }
    }

    public void flush() throws MetaDataExecutionException {
        if (!this.purgedPersistentIdentifiers.isEmpty()) {
            this.persistentIdentifierRepository.insert(PurgedPersistentIdentifier.convertListToDocumentList(this.purgedPersistentIdentifiers));
            this.purgedPersistentIdentifiers.clear();
        }
    }

    public List<PurgedPersistentIdentifier> getPurgedPersistentIdentifiers() {
        return this.purgedPersistentIdentifiers;
    }
}

