/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.reconstruction.domain;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.metadata.core.config.MetaDataConfiguration;
import fr.gouv.vitam.metadata.core.reconstruction.domain.OperationReportParser;
import fr.gouv.vitam.metadata.core.reconstruction.domain.extractor.PurgedPersistentIdentifierExtractorFactory;
import fr.gouv.vitam.metadata.core.reconstruction.exception.ReconstructionException;
import fr.gouv.vitam.metadata.core.reconstruction.model.ReconstructionOperation;
import fr.gouv.vitam.metadata.core.reconstruction.repository.OperationReportRepository;
import fr.gouv.vitam.metadata.core.reconstruction.repository.PersistentIdentifierRepository;
import fr.gouv.vitam.metadata.core.reconstruction.repository.ReconstructionOperationRepository;
import fr.gouv.vitam.metadata.core.reconstruction.repository.ReconstructionResponse;
import java.time.LocalDateTime;
import java.util.List;

public class PersistentIdentifierReconstructionManager {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(PersistentIdentifierReconstructionManager.class);
    private final OperationReportParser operationReportParser;
    private final ReconstructionOperationRepository reconstructionOperationRepository;

    public PersistentIdentifierReconstructionManager(OperationReportRepository operationReportRepository, ReconstructionOperationRepository reconstructionOperationRepository, MetaDataConfiguration metaDataConfiguration, PersistentIdentifierRepository persistentIdentifierRepository) {
        this.reconstructionOperationRepository = reconstructionOperationRepository;
        this.operationReportParser = new OperationReportParser(operationReportRepository, metaDataConfiguration, persistentIdentifierRepository, new PurgedPersistentIdentifierExtractorFactory());
    }

    public PersistentIdentifierReconstructionManager(ReconstructionOperationRepository reconstructionOperationRepository, OperationReportParser operationReportParser) {
        this.reconstructionOperationRepository = reconstructionOperationRepository;
        this.operationReportParser = operationReportParser;
    }

    public ReconstructionResponse reconstruct(LocalDateTime startDate, LocalDateTime endDate) {
        LocalDateTime lastSuccessfulOperationDate = startDate;
        try {
            List<ReconstructionOperation> reconstructionOperations = this.reconstructionOperationRepository.fetchReconstructionOperations(startDate, endDate);
            LOGGER.info("Persistent Identifier Reconstruction : number of operations to reconstruct between dates {} and {} : {}", new Object[]{startDate, endDate, reconstructionOperations.size()});
            for (ReconstructionOperation operation : reconstructionOperations) {
                lastSuccessfulOperationDate = this.operationReportParser.processReportFromOperation(operation);
            }
        }
        catch (ReconstructionException e) {
            LOGGER.error("Persistent Identifier Reconstruction failed ", (Throwable)((Object)e));
            return new ReconstructionResponse.Builder().status(ReconstructionResponse.ReconstructionStatus.FAILURE).lastSuccessfulOperationDate(lastSuccessfulOperationDate).build();
        }
        return new ReconstructionResponse.Builder().status(ReconstructionResponse.ReconstructionStatus.SUCCESS).lastSuccessfulOperationDate(lastSuccessfulOperationDate).build();
    }
}

