/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.reconstruction.domain;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.core.config.MetaDataConfiguration;
import fr.gouv.vitam.metadata.core.reconstruction.domain.PurgedPersistentIdentifierBulkInserter;
import fr.gouv.vitam.metadata.core.reconstruction.domain.extractor.PurgedPersistentIdentifierExtractorFactory;
import fr.gouv.vitam.metadata.core.reconstruction.exception.ReconstructionException;
import fr.gouv.vitam.metadata.core.reconstruction.model.PurgedPersistentIdentifier;
import fr.gouv.vitam.metadata.core.reconstruction.model.ReconstructionOperation;
import fr.gouv.vitam.metadata.core.reconstruction.model.ReportLine;
import fr.gouv.vitam.metadata.core.reconstruction.repository.OperationReportRepository;
import fr.gouv.vitam.metadata.core.reconstruction.repository.PersistentIdentifierRepository;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class OperationReportParser {
    public static final String UNIT = "Unit";
    public static final String OBJECT_GROUP = "ObjectGroup";
    public static final String ELIMINATION_ACTION = "ELIMINATION_ACTION";
    public static final String DELETE_GOT_VERSIONS = "DELETE_GOT_VERSIONS";
    public static final String DETAIL_TYPE = "detailType";
    public static final String PARAMS = "params";
    public static final String TYPE = "type";
    public static final String TRANSFER_REPLY = "TRANSFER_REPLY";
    private final OperationReportRepository operationReportRepository;
    private final PurgedPersistentIdentifierExtractorFactory purgedPersistentIdentifierExtractorFactory;
    private final MetaDataConfiguration metaDataConfiguration;
    private final PersistentIdentifierRepository persistentIdentifierRepository;

    public OperationReportParser(OperationReportRepository operationReportRepository, MetaDataConfiguration metaDataConfiguration, PersistentIdentifierRepository persistentIdentifierRepository, PurgedPersistentIdentifierExtractorFactory purgedPersistentIdentifierExtractorFactory) {
        this.operationReportRepository = operationReportRepository;
        this.purgedPersistentIdentifierExtractorFactory = purgedPersistentIdentifierExtractorFactory;
        this.metaDataConfiguration = metaDataConfiguration;
        this.persistentIdentifierRepository = persistentIdentifierRepository;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public LocalDateTime processReportFromOperation(ReconstructionOperation operation) throws ReconstructionException {
        PurgedPersistentIdentifierBulkInserter purgedPersistentIdentifierBulkInserter = new PurgedPersistentIdentifierBulkInserter(this.metaDataConfiguration, this.persistentIdentifierRepository);
        try (InputStream is = this.operationReportRepository.retrieveJsonReportForOperation(operation.getId());){
            LocalDateTime localDateTime;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                Iterator lines = bufferedReader.lines().iterator();
                while (lines.hasNext()) {
                    JsonNode element = JsonHandler.getFromString((String)((String)lines.next()));
                    this.processJsonElement(element, operation, purgedPersistentIdentifierBulkInserter);
                }
                purgedPersistentIdentifierBulkInserter.flush();
                localDateTime = Optional.ofNullable(operation.getLastPersistedDate()).filter(date -> !date.isBlank()).map(LocalDateUtil::parseMongoFormattedDate).orElse(LocalDateUtil.now());
            }
            return localDateTime;
        }
        catch (InvalidParseOperationException | MetaDataExecutionException | ReconstructionException | IOException | DateTimeParseException e) {
            throw new ReconstructionException("Could not process report operation : " + operation.getId(), (Throwable)e);
        }
    }

    private void processJsonElement(JsonNode element, ReconstructionOperation operation, PurgedPersistentIdentifierBulkInserter purgedPersistentIdentifierBulkInserter) throws MetaDataExecutionException {
        ReportLine reportLine = this.pullOutReportLineFromJsonElement(element, operation);
        if (!ReportLine.ReportLineType.UNDEFINED.equals((Object)reportLine.getType())) {
            List<PurgedPersistentIdentifier> purgedPersistentIdentifiers = this.purgedPersistentIdentifierExtractorFactory.instance(reportLine.getType()).extractPurgedPersistentIdentifier(reportLine.getLine(), operation);
            for (PurgedPersistentIdentifier purgedPersistentIdentifier : purgedPersistentIdentifiers) {
                purgedPersistentIdentifierBulkInserter.append(purgedPersistentIdentifier);
            }
        }
    }

    private ReportLine pullOutReportLineFromJsonElement(JsonNode element, ReconstructionOperation operation) throws MetaDataExecutionException {
        String operationType;
        switch (operationType = operation.getType()) {
            case "ELIMINATION_ACTION": {
                return this.getReportLineFromEliminationReport(element);
            }
            case "DELETE_GOT_VERSIONS": {
                return this.getReportLineFromDeletingVersionsReport(element);
            }
            case "TRANSFER_REPLY": {
                return this.getReportLineFromTransferredReport(element);
            }
        }
        throw new MetaDataExecutionException("Illegal reconstruction type parameter");
    }

    private ReportLine getReportLineFromDeletingVersionsReport(JsonNode element) {
        if (element.has(DETAIL_TYPE) && DELETE_GOT_VERSIONS.equals(element.get(DETAIL_TYPE).asText())) {
            return new ReportLine(element, ReportLine.ReportLineType.DELETED_GOT_VERSION);
        }
        return new ReportLine(element, ReportLine.ReportLineType.UNDEFINED);
    }

    private ReportLine getReportLineFromEliminationReport(JsonNode element) throws MetaDataExecutionException {
        JsonNode params;
        if (element.has(PARAMS) && (params = element.get(PARAMS)).has(TYPE)) {
            String type;
            switch (type = params.get(TYPE).asText()) {
                case "Unit": {
                    return new ReportLine(params, ReportLine.ReportLineType.DELETED_UNIT);
                }
                case "ObjectGroup": {
                    return new ReportLine(params, ReportLine.ReportLineType.DELETED_OBJECT_GROUP);
                }
            }
            throw new MetaDataExecutionException("Illegal reconstruction type parameter '" + type + "'");
        }
        return new ReportLine(element, ReportLine.ReportLineType.UNDEFINED);
    }

    private ReportLine getReportLineFromTransferredReport(JsonNode element) throws MetaDataExecutionException {
        JsonNode params;
        if (element.has(PARAMS) && (params = element.get(PARAMS)).has(TYPE)) {
            String type;
            switch (type = params.get(TYPE).asText()) {
                case "Unit": {
                    return new ReportLine(params, ReportLine.ReportLineType.TRANSFERRED_UNIT);
                }
                case "ObjectGroup": {
                    return new ReportLine(params, ReportLine.ReportLineType.TRANSFERRED_OBJECT_GROUP);
                }
            }
            throw new MetaDataExecutionException("Illegal reconstruction type parameter '" + type + "'");
        }
        return new ReportLine(element, ReportLine.ReportLineType.UNDEFINED);
    }
}

