/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.reconstruction.domain;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.offset.OffsetRepository;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Optional;

public class OffsetManager {
    private final OffsetRepository offsetRepository;

    public OffsetManager(OffsetRepository offsetRepository) {
        this.offsetRepository = offsetRepository;
    }

    public LocalDateTime retrieveEndDateWithDelay(long persistentIdentifierReconstructionDelayInMinutes) {
        return LocalDateUtil.now().minusMinutes(persistentIdentifierReconstructionDelayInMinutes);
    }

    public LocalDateTime retrieveLastReconstructionDateFromOffset(Integer tenant) {
        long lastReconstructedOffset = Optional.of(this.offsetRepository.findOffsetBy(tenant.intValue(), VitamConfiguration.getDefaultStrategy(), "PERSISTENT_IDENTIFIER")).filter(t -> t != 0L).orElse(Instant.EPOCH.toEpochMilli());
        return LocalDateUtil.fromEpochMilliUTC((long)lastReconstructedOffset);
    }

    public void saveNextReconstructionDateInOffset(Integer tenant, LocalDateTime lastSuccessfulOperationDate) {
        long timestamp = LocalDateUtil.toEpochMilliUTC((LocalDateTime)lastSuccessfulOperationDate);
        this.offsetRepository.createOrUpdateOffset(tenant.intValue(), VitamConfiguration.getDefaultStrategy(), "PERSISTENT_IDENTIFIER", timestamp);
    }
}

