/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.model;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.metadata.core.validation.MetadataValidationErrorCode;

public class UpdatedDocument {
    private String documentId;
    private UpdatedDocumentStatus status;
    private JsonNode beforeUpdate;
    private JsonNode afterUpdate;
    private String failureMessage;
    private MetadataValidationErrorCode validationErrorCode;
    private boolean updated;

    public UpdatedDocument() {
    }

    public UpdatedDocument(String documentId, JsonNode beforeUpdate, JsonNode afterUpdate, boolean updated) {
        this.documentId = documentId;
        this.beforeUpdate = beforeUpdate;
        this.afterUpdate = afterUpdate;
        this.updated = updated;
        this.status = UpdatedDocumentStatus.SUCCESS;
    }

    public UpdatedDocument(String documentId, JsonNode beforeUpdate, JsonNode afterUpdate, boolean updated, MetadataValidationErrorCode validationErrorCode, String failureMessage) {
        this(documentId, beforeUpdate, afterUpdate, updated);
        this.validationErrorCode = validationErrorCode;
        this.status = UpdatedDocumentStatus.FAILED;
        this.failureMessage = failureMessage;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public UpdatedDocumentStatus getStatus() {
        return this.status;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public MetadataValidationErrorCode getValidationErrorCode() {
        return this.validationErrorCode;
    }

    public UpdatedDocument setDocumentId(String documentId) {
        this.documentId = documentId;
        return this;
    }

    public UpdatedDocument setDocumentId(MetadataValidationErrorCode validationErrorCode) {
        this.validationErrorCode = validationErrorCode;
        return this;
    }

    public UpdatedDocument setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
        return this;
    }

    public UpdatedDocument setStatus(UpdatedDocumentStatus status) {
        this.status = status;
        return this;
    }

    public JsonNode getBeforeUpdate() {
        return this.beforeUpdate;
    }

    public UpdatedDocument setBeforeUpdate(JsonNode beforeUpdate) {
        this.beforeUpdate = beforeUpdate;
        return this;
    }

    public JsonNode getAfterUpdate() {
        return this.afterUpdate;
    }

    public UpdatedDocument setAfterUpdate(JsonNode afterUpdate) {
        this.afterUpdate = afterUpdate;
        return this;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public String toString() {
        return JsonHandler.prettyPrint((Object)this);
    }

    public static enum UpdatedDocumentStatus {
        SUCCESS,
        FAILED;

    }
}

