/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.migration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.action.Action;
import fr.gouv.vitam.common.database.builder.query.action.UpdateActionHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InternalServerException;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.exception.VitamException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProcessAction;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.api.exception.MetaDataNotFoundException;
import fr.gouv.vitam.metadata.core.MetaDataImpl;
import fr.gouv.vitam.metadata.core.model.MetadataResult;
import fr.gouv.vitam.processing.engine.core.operation.OperationContextException;
import fr.gouv.vitam.processing.engine.core.operation.OperationContextModel;
import fr.gouv.vitam.processing.engine.core.operation.OperationContextMonitor;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClient;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;

public class UnitsWithTransferRequestsMigrationService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(UnitsWithTransferRequestsMigrationService.class);
    private static final String QUERY_FILE = "query.json";
    private static final int MAX_RETRIES = 1000;
    private static final int WAIT_DELAY_IN_MS_BEFORE_RETRIES = 5000;
    private final MetaDataImpl metadataImpl;
    private final ProcessingManagementClientFactory processingManagementClientFactory;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final WorkspaceClientFactory workspaceClientFactory;

    public UnitsWithTransferRequestsMigrationService(MetaDataImpl metadataImpl) {
        this.metadataImpl = metadataImpl;
        this.processingManagementClientFactory = ProcessingManagementClientFactory.getInstance();
        this.logbookOperationsClientFactory = LogbookOperationsClientFactory.getInstance();
        this.workspaceClientFactory = WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM);
    }

    public boolean migrateUnits(int threshold) throws InvalidCreateOperationException, VitamException, OperationContextException {
        int tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        String operationId = VitamThreadUtils.getVitamSession().getRequestId();
        LOGGER.warn("Start migration for units with transfer request for tenant " + tenantId + " with threshold " + threshold);
        if (threshold <= 0) {
            throw new IllegalArgumentException("Threshold must be greater than 0");
        }
        long hits = this.countUnitsToMigrate();
        if (hits == 0L) {
            LOGGER.info("No migration required");
            return false;
        }
        if (hits > (long)threshold) {
            throw new IllegalArgumentException(String.format("Cannot proceed to migration for tenant %d. Too many units found %d.", tenantId, hits));
        }
        LOGGER.warn("Migration required for tenant {}. Units to migrate: {}", (Object)tenantId, (Object)hits);
        this.runUnitUpdateWorkflow(threshold, operationId);
        LOGGER.info("Update process " + operationId + " started for tenant " + tenantId);
        this.awaitForProcessTermination(operationId);
        LOGGER.info("Update process " + operationId + " completed for tenant " + tenantId);
        return true;
    }

    private long countUnitsToMigrate() throws InvalidCreateOperationException, MetaDataExecutionException, InvalidParseOperationException, MetaDataDocumentSizeException, MetaDataNotFoundException, BadRequestException, VitamDBException {
        SelectMultiQuery query = new SelectMultiQuery();
        query.addQueries(new Query[]{QueryHelper.exists((String)"#opts")});
        query.setLimitFilter(0L, 1L);
        query.trackTotalHits(true);
        MetadataResult metadataResult = this.metadataImpl.selectUnitsByQuery((JsonNode)query.getFinalSelect());
        return metadataResult.getHits().getTotal();
    }

    private void runUnitUpdateWorkflow(int threshold, String operationId) throws InvalidGuidOperationException, LogbookClientBadRequestException, LogbookClientAlreadyExistsException, LogbookClientServerException, ContentAddressableStorageServerException, InvalidParseOperationException, OperationContextException, BadRequestException, InternalServerException, VitamClientException, InvalidCreateOperationException {
        ObjectNode queryDsl = UnitsWithTransferRequestsMigrationService.createUpdateQuery(threshold);
        try (ProcessingManagementClient processingClient = this.processingManagementClientFactory.getClient();
             LogbookOperationsClient logbookOperationsClient = this.logbookOperationsClientFactory.getClient();
             WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
            LogbookOperationParameters initParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)GUIDReader.getGUID((String)operationId), (String)Contexts.MASS_UPDATE_UNIT_DESC.getEventType(), (GUID)GUIDReader.getGUID((String)operationId), (LogbookTypeProcess)LogbookTypeProcess.MASS_UPDATE, (StatusCode)StatusCode.STARTED, (String)VitamLogbookMessages.getCodeOp((String)Contexts.MASS_UPDATE_UNIT_DESC.getEventType(), (StatusCode)StatusCode.STARTED), (GUID)GUIDReader.getGUID((String)operationId));
            logbookOperationsClient.create(new LogbookOperationParameters[]{initParameters});
            workspaceClient.createContainer(operationId);
            workspaceClient.putObject(operationId, "operation_context.json", JsonHandler.writeToInpustream((Object)OperationContextModel.get((Object)queryDsl)));
            workspaceClient.putObject(operationId, QUERY_FILE, JsonHandler.writeToInpustream((Object)queryDsl));
            OperationContextMonitor.compressInWorkspace((WorkspaceClientFactory)this.workspaceClientFactory, (String)operationId, (LogbookTypeProcess)Contexts.MASS_UPDATE_UNIT_DESC.getLogbookTypeProcess(), (String[])new String[]{"operation_context.json"});
            processingClient.initVitamProcess(operationId, Contexts.MASS_UPDATE_UNIT_DESC.name());
            processingClient.executeOperationProcess(operationId, Contexts.MASS_UPDATE_UNIT_DESC.name(), ProcessAction.RESUME.getValue());
        }
    }

    private static ObjectNode createUpdateQuery(int threshold) throws InvalidCreateOperationException {
        UpdateMultiQuery updateMultiQuery = new UpdateMultiQuery();
        updateMultiQuery.addQueries(new Query[]{QueryHelper.exists((String)"#opts")});
        updateMultiQuery.addActions(new Action[]{UpdateActionHelper.unset((String[])new String[]{"NonExistingField-" + GUIDFactory.newGUID()})});
        updateMultiQuery.setThreshold(Long.valueOf(threshold));
        return updateMultiQuery.getFinalUpdate();
    }

    private void awaitForProcessTermination(String operationId) throws VitamClientException, InternalServerException, BadRequestException, MetaDataExecutionException {
        for (int i = 0; i < 1000; ++i) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            try (ProcessingManagementClient processingClient = this.processingManagementClientFactory.getClient();){
                ItemStatus operationProcessStatus = processingClient.getOperationProcessStatus(operationId);
                if (!UnitsWithTransferRequestsMigrationService.checkProcessCompletion(operationProcessStatus, operationId)) continue;
                UnitsWithTransferRequestsMigrationService.checkCompletedProcessStatus(operationProcessStatus, operationId);
            }
            return;
        }
        throw new MetaDataExecutionException("Process " + operationId + " timed out");
    }

    private static boolean checkProcessCompletion(ItemStatus operationProcessStatus, String operationId) throws MetaDataExecutionException {
        switch (operationProcessStatus.getGlobalState()) {
            case RUNNING: {
                LOGGER.info("Process " + operationId + " is still running.");
                return false;
            }
            case PAUSE: {
                throw new MetaDataExecutionException("Process " + operationId + " is paused.");
            }
            case COMPLETED: {
                LOGGER.info("Process " + operationId + " completed.");
                return true;
            }
        }
        throw new IllegalStateException("Unexpected value: " + operationProcessStatus.getGlobalState());
    }

    private static void checkCompletedProcessStatus(ItemStatus operationProcessStatus, String operationId) throws MetaDataExecutionException {
        switch (operationProcessStatus.getGlobalStatus()) {
            case OK: 
            case STARTED: 
            case WARNING: {
                LOGGER.info("Process {} is completed successfully (status: {})", (Object)operationId, (Object)operationProcessStatus.getGlobalState());
                break;
            }
            case KO: {
                throw new MetaDataExecutionException("Process " + operationId + " is KO.");
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + operationProcessStatus.getGlobalStatus());
            }
        }
    }
}

