/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.metrics;

import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.metrics.PassiveExpiringCache;
import fr.gouv.vitam.metadata.core.database.collections.MetadataCollections;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

@ThreadSafe
public class MetadataReconstructionMetricsCache {
    private final PassiveExpiringCache<Triple<MetadataCollections, Integer, String>, LocalDateTime> documentReconstructionStatsCache;
    private final PassiveExpiringCache<MetadataCollections, LocalDateTime> graphReconstructionStatsCache;

    public MetadataReconstructionMetricsCache(long cacheDuration, TimeUnit cacheDurationUnit) {
        this.documentReconstructionStatsCache = new PassiveExpiringCache(cacheDuration, cacheDurationUnit);
        this.graphReconstructionStatsCache = new PassiveExpiringCache(cacheDuration, cacheDurationUnit);
    }

    public void registerLastDocumentReconstructionDate(MetadataCollections metadataCollection, int tenant, String strategy, LocalDateTime lastDocumentReconstructionDate) {
        ParametersChecker.checkParameter((String)"Missing metadataCollection", (Object[])new Object[]{metadataCollection});
        ParametersChecker.checkParameter((String)"Missing strategy", (String[])new String[]{strategy});
        ParametersChecker.checkParameter((String)"Missing lastDocumentReconstructionDate", (Object[])new Object[]{lastDocumentReconstructionDate});
        ImmutableTriple metadataKey = new ImmutableTriple((Object)metadataCollection, (Object)tenant, (Object)strategy);
        this.documentReconstructionStatsCache.put((Object)metadataKey, (Object)lastDocumentReconstructionDate);
    }

    public Duration getDocumentReconstructionLatency(MetadataCollections metadataCollection, int tenant, String strategy) {
        ParametersChecker.checkParameter((String)"Missing metadataCollection", (Object[])new Object[]{metadataCollection});
        ParametersChecker.checkParameter((String)"Missing strategy", (String[])new String[]{strategy});
        ImmutableTriple metadataKey = new ImmutableTriple((Object)metadataCollection, (Object)tenant, (Object)strategy);
        LocalDateTime lastDocumentReconstructionDate = (LocalDateTime)this.documentReconstructionStatsCache.get((Object)metadataKey);
        if (lastDocumentReconstructionDate == null) {
            return null;
        }
        return Duration.between(lastDocumentReconstructionDate, LocalDateUtil.now());
    }

    public void registerLastGraphReconstructionDate(MetadataCollections metadataCollection, LocalDateTime lastGraphReconstructionDate) {
        ParametersChecker.checkParameter((String)"Missing metadataCollection", (Object[])new Object[]{metadataCollection});
        ParametersChecker.checkParameter((String)"Missing lastGraphReconstructionDate", (Object[])new Object[]{lastGraphReconstructionDate});
        this.graphReconstructionStatsCache.put((Object)metadataCollection, (Object)lastGraphReconstructionDate);
    }

    public Duration getGraphReconstructionLatency(MetadataCollections metadataCollection) {
        ParametersChecker.checkParameter((String)"Missing metadataCollection", (Object[])new Object[]{metadataCollection});
        LocalDateTime lastGraphReconstructionDate = (LocalDateTime)this.graphReconstructionStatsCache.get((Object)metadataCollection);
        if (lastGraphReconstructionDate == null) {
            return null;
        }
        return Duration.between(lastGraphReconstructionDate, LocalDateUtil.now());
    }
}

