/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.metrics;

import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.metrics.GaugeUtils;
import fr.gouv.vitam.metadata.core.database.collections.MetadataCollections;
import fr.gouv.vitam.metadata.core.metrics.MetadataReconstructionMetricsCache;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MetadataReconstructionMetrics {
    private static final String TENANT_LABEL = "tenant";
    private static final String COLLECTION_LABEL = "collection";
    private static final String STRATEGY_LABEL = "strategy";
    private static final AtomicBoolean isInitialized = new AtomicBoolean(false);

    private MetadataReconstructionMetrics() {
    }

    public static synchronized void initialize(List<String> storageStrategies, MetadataReconstructionMetricsCache reconstructionMetricsCache) {
        if (isInitialized.get()) {
            return;
        }
        GaugeUtils.createCustomGauge((String)"vitam_metadata_reconstruction_metadata_latency_seconds", (String)"Metadata document reconstruction latency (in seconds)", List.of(TENANT_LABEL, COLLECTION_LABEL, STRATEGY_LABEL), () -> MetadataReconstructionMetrics.collectDocumentReconstructionMetrics(storageStrategies, reconstructionMetricsCache)).register();
        GaugeUtils.createCustomGauge((String)"vitam_metadata_reconstruction_graph_latency_seconds", (String)"Metadata graph reconstruction latency (in seconds)", List.of(COLLECTION_LABEL), () -> MetadataReconstructionMetrics.collectGraphReconstructionMetrics(reconstructionMetricsCache)).register();
        isInitialized.set(true);
    }

    private static Map<List<String>, Double> collectDocumentReconstructionMetrics(List<String> storageStrategies, MetadataReconstructionMetricsCache reconstructionMetricsCache) {
        HashMap<List<String>, Double> metricsByLabelValues = new HashMap<List<String>, Double>();
        List<MetadataCollections> metadataCollections = List.of(MetadataCollections.UNIT, MetadataCollections.OBJECTGROUP);
        for (MetadataCollections metadataCollection : metadataCollections) {
            for (Integer tenant : VitamConfiguration.getTenants()) {
                for (String storageStrategy : storageStrategies) {
                    Duration durationSinceLastReconstruction = reconstructionMetricsCache.getDocumentReconstructionLatency(metadataCollection, tenant, storageStrategy);
                    List<String> labelValues = List.of(Integer.toString(tenant), metadataCollection.getName().toLowerCase(), storageStrategy);
                    metricsByLabelValues.put(labelValues, MetadataReconstructionMetrics.getReconstructionLatency(durationSinceLastReconstruction));
                }
            }
        }
        return metricsByLabelValues;
    }

    private static Map<List<String>, Double> collectGraphReconstructionMetrics(MetadataReconstructionMetricsCache reconstructionMetricsCache) {
        HashMap<List<String>, Double> metricsByLabelValues = new HashMap<List<String>, Double>();
        List<MetadataCollections> metadataCollections = List.of(MetadataCollections.UNIT, MetadataCollections.OBJECTGROUP);
        for (MetadataCollections metadataCollection : metadataCollections) {
            Duration durationSinceLastReconstruction = reconstructionMetricsCache.getGraphReconstructionLatency(metadataCollection);
            List<String> labelValues = List.of(metadataCollection.getName().toLowerCase());
            metricsByLabelValues.put(labelValues, MetadataReconstructionMetrics.getReconstructionLatency(durationSinceLastReconstruction));
        }
        return metricsByLabelValues;
    }

    private static double getReconstructionLatency(Duration durationSinceLastReconstruction) {
        return durationSinceLastReconstruction == null ? Double.POSITIVE_INFINITY : Math.max(0.0, (double)durationSinceLastReconstruction.toSeconds());
    }
}

