/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.mapping;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.metadata.core.config.ElasticsearchExternalMetadataMapping;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;

public class MappingLoader {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MappingLoader.class);
    private List<ElasticsearchExternalMetadataMapping> mappingData;
    private static final String UNIT = "UNIT";
    private static final String OBJECTGROUP = "OBJECTGROUP";

    public MappingLoader(List<ElasticsearchExternalMetadataMapping> mappingData) {
        ParametersChecker.checkParameter((String)"elasticsearch mapping configuration files not found : these are mandatory files for starting the metadata server", (Object[])new Object[]{mappingData});
        this.checkMappingConfiguration(mappingData);
        this.mappingData = mappingData;
    }

    public InputStream loadMapping(String collections) throws IOException {
        switch (collections) {
            case "UNIT": {
                return this.getMappingAsInputStream(this.mappingData.get(0).getMappingFile());
            }
            case "OBJECTGROUP": {
                return this.getMappingAsInputStream(this.mappingData.get(1).getMappingFile());
            }
        }
        throw new VitamRuntimeException("The given collection is not Unit/ObjectGroup");
    }

    private InputStream getMappingAsInputStream(String mappingFile) throws FileNotFoundException {
        try {
            return Files.newInputStream(Paths.get(mappingFile, new String[0]), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("The mapping File not found");
            throw new FileNotFoundException(e.getMessage());
        }
    }

    private void checkMappingConfiguration(List<ElasticsearchExternalMetadataMapping> mappingConfig) {
        long missingCount = mappingConfig.stream().filter(mapping -> {
            try {
                return !PropertiesUtils.findFile((String)mapping.getMappingFile()).exists();
            }
            catch (IOException e) {
                LOGGER.error("The mapping file path not found" + e);
                throw new RuntimeException(e);
            }
        }).count();
        if (missingCount > 0L) {
            LOGGER.error("One or many mapping files are missing ... the mapping file of Unit or ObjectGroup ? or may be both !");
            throw new VitamRuntimeException("Error : elasticsearch mapping file not found");
        }
    }

    public List<ElasticsearchExternalMetadataMapping> getElasticsearchExternalMappings() {
        return this.mappingData;
    }
}

