/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.graph;

import com.google.common.annotations.VisibleForTesting;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Projections;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.api.VitamRepositoryProvider;
import fr.gouv.vitam.common.database.utils.MetadataDocumentHelper;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.metrics.VitamCommonMetrics;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.thread.VitamThreadPoolExecutor;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.metadata.core.database.collections.MetadataCollections;
import fr.gouv.vitam.metadata.core.graph.StoreGraphException;
import fr.gouv.vitam.metadata.core.metrics.CommonMetadataMetrics;
import fr.gouv.vitam.metadata.core.reconstruction.service.RestoreBackupService;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageAlreadyExistsClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageNotFoundClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.model.Order;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageAlreadyExistException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import fr.gouv.vitam.workspace.common.CompressInformation;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.Document;
import org.bson.conversions.Bson;

public class StoreGraphService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(StoreGraphService.class);
    public static final LocalDateTime INITIAL_START_DATE = LocalDateUtil.EPOCH;
    public static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss-SSS");
    public static final String GRAPH = "graph";
    public static final String UNDERSCORE = "_";
    public static final String ZIP_EXTENTION = ".zip";
    public static final String ZIP_PREFIX_NAME = "store_graph_";
    public static final String $_GTE = "$gte";
    public static final String $_LT = "$lt";
    static final int LAST_GRAPHSTORE_OFFERLOG_BATCH_SIZE = 1;
    private VitamRepositoryProvider vitamRepositoryProvider;
    private RestoreBackupService restoreBackupService;
    private final WorkspaceClientFactory workspaceClientFactory;
    private final StorageClientFactory storageClientFactory;
    private static AtomicBoolean alreadyRunningLock = new AtomicBoolean(false);

    @VisibleForTesting
    public StoreGraphService(VitamRepositoryProvider vitamRepositoryProvider, RestoreBackupService restoreBackupService, WorkspaceClientFactory workspaceClientFactory, StorageClientFactory storageClientFactory) {
        this.vitamRepositoryProvider = vitamRepositoryProvider;
        this.restoreBackupService = restoreBackupService;
        this.workspaceClientFactory = workspaceClientFactory;
        this.storageClientFactory = storageClientFactory;
    }

    public StoreGraphService(VitamRepositoryProvider vitamRepositoryProvider) {
        this.vitamRepositoryProvider = vitamRepositoryProvider;
        this.restoreBackupService = new RestoreBackupService();
        this.workspaceClientFactory = WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM);
        this.storageClientFactory = StorageClientFactory.getInstance();
    }

    public LocalDateTime getLastGraphStoreDate(MetadataCollections metadataCollections) throws StoreGraphException {
        try {
            DataCategory dataCategory = this.getDataCategory(metadataCollections);
            Iterator<OfferLog> offerLogIterator = this.restoreBackupService.getListing(VitamConfiguration.getDefaultStrategy(), null, dataCategory, null, null, Order.DESC, 1);
            if (!offerLogIterator.hasNext()) {
                return INITIAL_START_DATE;
            }
            return StoreGraphService.parseGraphEndDateFromFileName(offerLogIterator.next().getFileName());
        }
        catch (Exception e) {
            throw new StoreGraphException(e);
        }
    }

    public static LocalDateTime parseGraphStartDateFromFileName(String fileName) {
        return LocalDateUtil.parse((String)fileName.split(UNDERSCORE, 2)[0], (DateTimeFormatter)formatter);
    }

    public static LocalDateTime parseGraphEndDateFromFileName(String fileName) {
        return LocalDateUtil.parse((String)fileName.split(UNDERSCORE, 2)[1], (DateTimeFormatter)formatter);
    }

    private DataCategory getDataCategory(MetadataCollections metadataCollections) throws StoreGraphException {
        DataCategory dataCategory;
        switch (metadataCollections) {
            case UNIT: {
                dataCategory = DataCategory.UNIT_GRAPH;
                break;
            }
            case OBJECTGROUP: {
                dataCategory = DataCategory.OBJECTGROUP_GRAPH;
                break;
            }
            default: {
                throw new StoreGraphException("DataCategory " + metadataCollections + " not managed");
            }
        }
        return dataCategory;
    }

    public boolean isInProgress() {
        return alreadyRunningLock.get();
    }

    public Map<MetadataCollections, Integer> tryStoreGraph() throws StoreGraphException {
        CommonMetadataMetrics.LOG_SHIPPING_COUNTER.inc();
        boolean tryStore = alreadyRunningLock.compareAndSet(false, true);
        HashMap<MetadataCollections, Integer> map = new HashMap<MetadataCollections, Integer>();
        map.put(MetadataCollections.UNIT, 0);
        map.put(MetadataCollections.OBJECTGROUP, 0);
        Integer totalTreatedDocuments = 0;
        if (tryStore) {
            LOGGER.info("Start Graph store GOT and UNIT ...");
            try {
                CompletableFuture[] futures = new CompletableFuture[]{this.createCompletableFeature(MetadataCollections.UNIT, map), this.createCompletableFeature(MetadataCollections.OBJECTGROUP, map)};
                CompletionStage result = ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(futures).thenApply(v -> Stream.of(futures).map(CompletableFuture::join).collect(Collectors.toList()))).thenApply(numberOfDocuments -> numberOfDocuments.stream().mapToInt(o -> o).sum())).exceptionally(th -> {
                    throw new RuntimeException((Throwable)th);
                });
                totalTreatedDocuments = (Integer)((CompletableFuture)result).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new StoreGraphException(e);
            }
            finally {
                alreadyRunningLock.set(false);
            }
            LOGGER.info("Graph store GOT and UNIT total : " + totalTreatedDocuments + " : (" + ((Object)map).toString() + ")");
        } else {
            LOGGER.info("Graph store is already running ...");
        }
        return map;
    }

    private CompletableFuture<Integer> createCompletableFeature(MetadataCollections metadataCollections, Map<MetadataCollections, Integer> map) {
        return CompletableFuture.supplyAsync(() -> {
            Integer numberOfDocuments = this.storeGraph(metadataCollections);
            map.put(metadataCollections, numberOfDocuments);
            return numberOfDocuments;
        }, (Executor)VitamThreadPoolExecutor.getDefaultExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Integer storeGraph(MetadataCollections metadataCollections) {
        GUID storeOperation = GUIDFactory.newGUID();
        VitamThreadUtils.getVitamSession().setTenantId(VitamConfiguration.getAdminTenant());
        VitamThreadUtils.getVitamSession().setRequestId(storeOperation);
        String containerName = storeOperation.getId();
        Histogram.Timer timer = ((Histogram.Child)CommonMetadataMetrics.LOG_SHIPPING_DURATION.labels(new String[]{metadataCollections.name()})).startTimer();
        try {
            String endDate;
            String startDate;
            block25: {
                LocalDateTime lastStoreDate;
                LOGGER.info("Start graph store " + metadataCollections.getName() + " ...");
                try {
                    lastStoreDate = this.getLastGraphStoreDate(metadataCollections);
                }
                catch (StoreGraphException e) {
                    ((Counter.Child)VitamCommonMetrics.CONSISTENCY_ERROR_COUNTER.labels(new String[]{String.valueOf(ParameterHelper.getTenantParameter()), "StoreGraph"})).inc();
                    LOGGER.error("[Consistency ERROR] : Error while getting the last store date from the offer ", (Throwable)((Object)e));
                    Integer n = 0;
                    timer.observeDuration();
                    return n;
                }
                LocalDateTime currentStoreDate = LocalDateUtil.now().minus(VitamConfiguration.getStoreGraphOverlapDelay().intValue(), ChronoUnit.SECONDS);
                if (currentStoreDate.isBefore(lastStoreDate)) {
                    ((Counter.Child)VitamCommonMetrics.CONSISTENCY_ERROR_COUNTER.labels(new String[]{String.valueOf(ParameterHelper.getTenantParameter()), "StoreGraph"})).inc();
                    LOGGER.error("[Consistency ERROR] : The last store date should not be newer than the current date. Someone have modified the file name in the offer ?!!");
                    Integer n = 0;
                    return n;
                }
                startDate = LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)lastStoreDate);
                endDate = LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)currentStoreDate);
                String graph_store_name = lastStoreDate.format(formatter) + UNDERSCORE + currentStoreDate.format(formatter);
                DataCategory dataCategory = this.getDataCategory(metadataCollections);
                String graphFolder = metadataCollections.name().toLowerCase() + "_graph";
                String graphZipName = ZIP_PREFIX_NAME + metadataCollections.name().toLowerCase() + ZIP_EXTENTION;
                this.tryCreateContainer(containerName, graphFolder);
                BasicDBObject query = this.getMongoQuery(startDate, endDate);
                Bson projection = this.getProjection(metadataCollections);
                MongoCursor cursor = this.vitamRepositoryProvider.getVitamMongoRepository(metadataCollections.getVitamCollection()).findDocuments((Bson)query, VitamConfiguration.getBatchSize()).projection(projection).iterator();
                ArrayList<Object> documents = new ArrayList<Document>();
                boolean is_graph_updated = false;
                int totalTreatedDocuments = 0;
                while (cursor.hasNext()) {
                    documents.add((Document)cursor.next());
                    if (cursor.hasNext() && documents.size() < VitamConfiguration.getBatchSize()) continue;
                    totalTreatedDocuments += documents.size();
                    this.storeInWorkspace(containerName, graphFolder, documents);
                    is_graph_updated = true;
                    documents = new ArrayList();
                }
                if (!is_graph_updated) break block25;
                this.zipAndSaveInOffer(dataCategory, containerName, graphFolder, graphZipName, graph_store_name);
                LOGGER.info("End save graph of " + metadataCollections.name() + " in the storage");
                Integer n = totalTreatedDocuments;
                try {
                    this.cleanWorkspace(containerName);
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e);
                }
                return n;
            }
            LOGGER.info("End without any save graph of " + metadataCollections.name() + " . No document found with updated graph");
            Integer n = 0;
            try {
                this.cleanWorkspace(containerName);
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
            }
            return n;
            catch (StoreGraphException e) {
                ((Counter.Child)VitamCommonMetrics.CONSISTENCY_ERROR_COUNTER.labels(new String[]{String.valueOf(ParameterHelper.getTenantParameter()), "StoreGraph"})).inc();
                LOGGER.error(String.format("[Consistency ERROR] : Error while graph store (%s) form (%s) to (%s)", metadataCollections.name(), startDate, endDate), (Throwable)((Object)e));
                Integer n2 = 0;
                try {
                    this.cleanWorkspace(containerName);
                }
                catch (Exception e2) {
                    LOGGER.error((Throwable)e2);
                }
                timer.observeDuration();
                return n2;
                {
                    catch (Throwable throwable) {
                        try {
                            this.cleanWorkspace(containerName);
                        }
                        catch (Exception e3) {
                            LOGGER.error((Throwable)e3);
                        }
                        throw throwable;
                    }
                }
            }
        }
        finally {
            timer.observeDuration();
        }
    }

    private Bson getProjection(MetadataCollections metadataCollections) throws StoreGraphException {
        switch (metadataCollections) {
            case UNIT: {
                return Projections.include((List)MetadataDocumentHelper.getComputedGraphUnitFields());
            }
            case OBJECTGROUP: {
                return Projections.include((List)MetadataDocumentHelper.getComputedGraphObjectGroupFields());
            }
        }
        throw new StoreGraphException("The collection " + metadataCollections + " is not managed");
    }

    private BasicDBObject getMongoQuery(String startDate, String endDate) {
        return new BasicDBObject("_glpd", (Object)new BasicDBObject($_GTE, (Object)startDate).append($_LT, (Object)endDate));
    }

    private void cleanWorkspace(String containerName) {
        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
            if (workspaceClient.isExistingContainer(containerName)) {
                workspaceClient.deleteContainer(containerName, true);
            }
        }
        catch (ContentAddressableStorageNotFoundException | ContentAddressableStorageServerException e) {
            LOGGER.error("Error while cleaning graph store container: ", e);
        }
    }

    private void tryCreateContainer(String containerName, String graphFolder) throws StoreGraphException {
        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
            if (!workspaceClient.isExistingContainer(containerName)) {
                workspaceClient.createContainer(containerName);
                workspaceClient.createFolder(containerName, graphFolder);
            }
        }
        catch (ContentAddressableStorageAlreadyExistException | ContentAddressableStorageServerException e) {
            throw new StoreGraphException(e);
        }
    }

    public void zipAndSaveInOffer(DataCategory dataCategory, String containerName, String graphFolder, String graphZipName, String graph_store_name) throws StoreGraphException {
        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
            CompressInformation compressInformation = new CompressInformation();
            Collections.addAll(compressInformation.getFiles(), graphFolder);
            compressInformation.setOutputFile(graphZipName);
            compressInformation.setOutputContainer(containerName);
            workspaceClient.compress(containerName, compressInformation);
        }
        catch (ContentAddressableStorageServerException e) {
            throw new StoreGraphException(e);
        }
        try (StorageClient storageClient = this.storageClientFactory.getClient();){
            ObjectDescription description = new ObjectDescription();
            description.setWorkspaceContainerGUID(containerName);
            description.setWorkspaceObjectURI(graphZipName);
            storageClient.storeFileFromWorkspace(VitamConfiguration.getDefaultStrategy(), dataCategory, graph_store_name, description);
        }
        catch (StorageAlreadyExistsClientException | StorageNotFoundClientException | StorageServerClientException e) {
            throw new StoreGraphException(e);
        }
    }

    public void storeInWorkspace(String containerName, String graphFolder, List<Document> documents) throws StoreGraphException {
        InputStream inputStream;
        try {
            inputStream = JsonHandler.writeToInpustream(documents);
        }
        catch (InvalidParseOperationException e) {
            throw new StoreGraphException(e);
        }
        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
            workspaceClient.putObject(containerName, graphFolder + "/" + GUIDFactory.newGUID().getId(), inputStream);
        }
        catch (ContentAddressableStorageServerException e) {
            throw new StoreGraphException(e);
        }
        finally {
            StreamUtils.closeSilently((InputStream)inputStream);
        }
    }
}

