/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.graph;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.InQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.utils.ScrollSpliterator;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.iterables.SpliteratorIterator;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.api.exception.MetaDataNotFoundException;
import fr.gouv.vitam.metadata.core.MetaDataImpl;
import fr.gouv.vitam.metadata.core.config.MetaDataConfiguration;
import fr.gouv.vitam.metadata.core.model.MetadataResult;
import fr.gouv.vitam.worker.core.distribution.JsonLineModel;
import fr.gouv.vitam.worker.core.distribution.JsonLineWriter;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import org.apache.commons.io.FileUtils;

public class ReclassificationDistributionService {
    private static final String JSONL_EXTENSION = ".jsonl";
    private static final String UNIT_LIST_TMP_FILE_PREFIX = "unit_export_";
    private static final String OBJECT_GROUP_LIST_TMP_FILE_PREFIX = "object_group_export_";
    private final WorkspaceClientFactory workspaceClientFactory;
    private final MetaDataImpl metaData;

    public ReclassificationDistributionService(MetaDataImpl metaData, MetaDataConfiguration configuration) {
        this(WorkspaceClientFactory.getInstance((WorkspaceType)(configuration.getCollectModule() != false ? WorkspaceType.COLLECT : WorkspaceType.VITAM)), metaData);
    }

    @VisibleForTesting
    ReclassificationDistributionService(WorkspaceClientFactory workspaceClientFactory, MetaDataImpl metaData) {
        this.workspaceClientFactory = workspaceClientFactory;
        this.metaData = metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReclassificationChildNodes(Set<String> unitIds, String unitsToUpdateJsonLineFileName, String objectGroupsToUpdateJsonLineFileName) throws IOException, InvalidParseOperationException, InvalidCreateOperationException {
        SelectMultiQuery select = this.createSelectRequest(unitIds);
        Iterator<JsonNode> iterator = this.executeSelectAsIterator(select);
        File tempUnitReportFile = null;
        File tempObjectGroupReportFile = null;
        try {
            tempUnitReportFile = File.createTempFile(UNIT_LIST_TMP_FILE_PREFIX, JSONL_EXTENSION, new File(VitamConfiguration.getVitamTmpFolder()));
            tempObjectGroupReportFile = File.createTempFile(OBJECT_GROUP_LIST_TMP_FILE_PREFIX, JSONL_EXTENSION, new File(VitamConfiguration.getVitamTmpFolder()));
            try (JsonLineWriter unitReportWriter = new JsonLineWriter((OutputStream)new FileOutputStream(tempUnitReportFile));
                 JsonLineWriter objectGroupReportWriter = new JsonLineWriter((OutputStream)new FileOutputStream(tempObjectGroupReportFile));){
                this.appendEntries(iterator, unitReportWriter, objectGroupReportWriter);
            }
            this.storeIntoWorkspace(unitsToUpdateJsonLineFileName, tempUnitReportFile);
            this.storeIntoWorkspace(objectGroupsToUpdateJsonLineFileName, tempObjectGroupReportFile);
        }
        catch (Throwable throwable) {
            FileUtils.deleteQuietly(tempUnitReportFile);
            FileUtils.deleteQuietly(tempObjectGroupReportFile);
            throw throwable;
        }
        FileUtils.deleteQuietly((File)tempUnitReportFile);
        FileUtils.deleteQuietly((File)tempObjectGroupReportFile);
    }

    private SelectMultiQuery createSelectRequest(Set<String> unitIds) throws InvalidCreateOperationException, InvalidParseOperationException {
        SelectMultiQuery select = new SelectMultiQuery();
        String[] parentUnitIds = unitIds.toArray(new String[0]);
        InQuery childrenUnitsQuery = QueryHelper.in((String)VitamFieldsHelper.allunitups(), (String[])parentUnitIds);
        InQuery parentsUnitsQuery = QueryHelper.in((String)VitamFieldsHelper.id(), (String[])parentUnitIds);
        BooleanQuery parentsAndProgenyUnits = QueryHelper.or().add(new Query[]{childrenUnitsQuery, parentsUnitsQuery});
        select.setQuery((Query)parentsAndProgenyUnits);
        select.addOrderByAscFilter(new String[]{VitamFieldsHelper.object()});
        select.addUsedProjection(new String[]{VitamFieldsHelper.id(), VitamFieldsHelper.object()});
        return select;
    }

    private Iterator<JsonNode> executeSelectAsIterator(SelectMultiQuery select) {
        ScrollSpliterator scrollRequest = new ScrollSpliterator(select, query -> {
            try {
                MetadataResult metadataResult = this.metaData.selectUnitsByQuery((JsonNode)query.getFinalSelect());
                return new RequestResponseOK(metadataResult.getQuery()).addAllResults(metadataResult.getResults()).addAllFacetResults(metadataResult.getFacetResults()).setHits(metadataResult.getHits());
            }
            catch (BadRequestException | InvalidParseOperationException | VitamDBException | MetaDataDocumentSizeException | MetaDataExecutionException | MetaDataNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }, VitamConfiguration.getElasticSearchScrollTimeoutInMilliseconds().intValue(), VitamConfiguration.getElasticSearchScrollLimit().intValue());
        return new SpliteratorIterator((Spliterator)scrollRequest);
    }

    private void appendEntries(Iterator<JsonNode> iterator, JsonLineWriter unitReportWriter, JsonLineWriter objectGroupReportWriter) throws IOException {
        String lastObjectGroupId = null;
        while (iterator.hasNext()) {
            JsonNode doc = iterator.next();
            String id = doc.get(VitamFieldsHelper.id()).textValue();
            String objectGroupId = doc.has(VitamFieldsHelper.object()) ? doc.get(VitamFieldsHelper.object()).textValue() : null;
            unitReportWriter.addEntry(new JsonLineModel(id));
            if (objectGroupId != null && !objectGroupId.equals(lastObjectGroupId)) {
                objectGroupReportWriter.addEntry(new JsonLineModel(objectGroupId));
            }
            lastObjectGroupId = objectGroupId;
        }
    }

    private void storeIntoWorkspace(String filename, File file) throws IOException {
        try (WorkspaceClient client = this.workspaceClientFactory.getClient();
             FileInputStream inputStream = new FileInputStream(file);){
            String containerName = VitamThreadUtils.getVitamSession().getRequestId();
            client.putObject(containerName, filename, (InputStream)inputStream);
        }
        catch (ContentAddressableStorageServerException e) {
            throw new IOException("Could not store file to workspace", e);
        }
    }
}

