/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.graph;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.mongodb.BasicDBObject;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataNotFoundException;
import fr.gouv.vitam.metadata.core.database.collections.MongoDbMetadataRepository;
import fr.gouv.vitam.metadata.core.database.collections.Unit;
import fr.gouv.vitam.metadata.core.database.collections.UnitGraphModel;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class GraphLoader
implements AutoCloseable {
    private static final Pattern pattern = Pattern.compile("loadAll failed to return a value for (.*)");
    private final MongoDbMetadataRepository<Unit> mongoDbMetadataRepository;
    static final BasicDBObject UNIT_VITAM_GRAPH_PROJECTION = new BasicDBObject("_up", (Object)1).append("_sp", (Object)1).append("_id", (Object)1).append("_og", (Object)1);
    private LoadingCache<String, UnitGraphModel> unitLoadingCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, UnitGraphModel>(){

        public UnitGraphModel load(String key) throws ExecutionException {
            return this.loadAll(Collections.singleton(key)).get(key);
        }

        public Map<String, UnitGraphModel> loadAll(Iterable<? extends String> keys) throws ExecutionException {
            return GraphLoader.this.computeGraphByIds(keys);
        }
    });

    public GraphLoader(MongoDbMetadataRepository<Unit> mongoDbMetadataRepository) {
        this.mongoDbMetadataRepository = mongoDbMetadataRepository;
    }

    public Map<String, UnitGraphModel> loadGraphInfo(Iterable<? extends String> ids) throws MetaDataNotFoundException {
        try {
            return this.unitLoadingCache.getAll(ids);
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            Matcher matcher = pattern.matcher(e.getMessage());
            if (matcher.matches()) {
                String id = matcher.group(1);
                throw new MetaDataNotFoundException("Cannot find parents: [" + id + "]");
            }
            throw new MetaDataNotFoundException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new VitamRuntimeException((Throwable)e);
        }
    }

    public void cleanCache() {
        this.unitLoadingCache.invalidateAll();
    }

    @Override
    public void close() {
        this.cleanCache();
    }

    private Map<String, UnitGraphModel> computeGraphByIds(Iterable<? extends String> ids) throws ExecutionException {
        List<Unit> units = this.mongoDbMetadataRepository.selectByIds(ids, UNIT_VITAM_GRAPH_PROJECTION);
        Set collectParent = units.stream().flatMap(unit -> unit.getUp().stream()).collect(Collectors.toSet());
        if (collectParent.isEmpty()) {
            return units.stream().map(UnitGraphModel::new).collect(Collectors.toMap(UnitGraphModel::id, Function.identity()));
        }
        ImmutableMap parents = this.unitLoadingCache.getAll(collectParent);
        return units.stream().map(arg_0 -> GraphLoader.lambda$computeGraphByIds$1((Map)parents, arg_0)).collect(Collectors.toMap(UnitGraphModel::id, Function.identity()));
    }

    private static /* synthetic */ UnitGraphModel lambda$computeGraphByIds$1(Map parents, Unit unit) {
        UnitGraphModel unitGraphModel = new UnitGraphModel(unit);
        for (String up : unit.getUp()) {
            UnitGraphModel graphParent = (UnitGraphModel)parents.get(up);
            unitGraphModel.addParent(graphParent);
        }
        return unitGraphModel;
    }
}

