/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.graph;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.mongodb.Function;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.cache.VitamCache;
import fr.gouv.vitam.common.database.api.VitamRepositoryProvider;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.parser.query.ParserTokens;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.utils.ScrollSpliterator;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.DatabaseException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.graph.GraphUtils;
import fr.gouv.vitam.common.iterables.SpliteratorIterator;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.GraphComputeResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.VitamAutoCloseable;
import fr.gouv.vitam.common.thread.ExecutorUtils;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.metadata.api.exception.MetaDataDocumentSizeException;
import fr.gouv.vitam.metadata.api.exception.MetaDataException;
import fr.gouv.vitam.metadata.api.exception.MetaDataExecutionException;
import fr.gouv.vitam.metadata.api.exception.MetaDataNotFoundException;
import fr.gouv.vitam.metadata.core.MetaDataImpl;
import fr.gouv.vitam.metadata.core.config.ElasticsearchMetadataIndexManager;
import fr.gouv.vitam.metadata.core.database.collections.MetadataCollections;
import fr.gouv.vitam.metadata.core.graph.GraphComputeCache;
import fr.gouv.vitam.metadata.core.graph.GraphRelation;
import fr.gouv.vitam.metadata.core.graph.api.GraphComputeService;
import fr.gouv.vitam.metadata.core.model.MetadataResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import joptsimple.internal.Strings;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.bson.Document;
import org.bson.conversions.Bson;

public class GraphComputeServiceImpl
implements GraphComputeService,
VitamAutoCloseable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(GraphComputeServiceImpl.class);
    private static final String $_SET = "$set";
    private static final String $_INC = "$inc";
    private static final String $_UNSET = "$unset";
    private static final int START_DEPTH = 1;
    private static GraphComputeService instance;
    private static final Integer concurrencyLevel;
    private static final ExecutorService executor;
    private final Map<Integer, AtomicBoolean> lockers = new HashMap<Integer, AtomicBoolean>();
    private final VitamCache<String, Document> cache;
    private final VitamRepositoryProvider vitamRepositoryProvider;
    private final MetaDataImpl metaData;
    private final ElasticsearchMetadataIndexManager indexManager;
    private String currentOperation = null;

    private GraphComputeServiceImpl(VitamRepositoryProvider vitamRepositoryProvider, MetaDataImpl metaData, VitamCache<String, Document> cache, ElasticsearchMetadataIndexManager indexManager, List<Integer> tenants) {
        this.vitamRepositoryProvider = vitamRepositoryProvider;
        this.metaData = metaData;
        this.cache = cache;
        this.indexManager = indexManager;
        tenants.forEach(tenant -> this.lockers.put((Integer)tenant, new AtomicBoolean(false)));
    }

    public static synchronized GraphComputeService initialize(VitamRepositoryProvider vitamRepositoryProvider, MetaDataImpl metaData, ElasticsearchMetadataIndexManager indexManager) {
        if (instance == null) {
            instance = new GraphComputeServiceImpl(vitamRepositoryProvider, metaData, GraphComputeCache.getInstance(), indexManager, VitamConfiguration.getTenants());
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphComputeResponse computeGraph(JsonNode queryDSL) throws MetaDataException {
        Integer tenant = VitamThreadUtils.getVitamSession().getTenantId();
        AtomicBoolean lock = this.lockers.get(tenant);
        boolean tryBuildGraph = lock.compareAndSet(false, true);
        if (!tryBuildGraph) {
            throw new MetaDataException("Compute graph process already in progress");
        }
        LOGGER.info("Starting metadata graph computation for tenant " + tenant);
        try {
            GraphComputeResponse response = new GraphComputeResponse();
            Iterator<String> unitIdsIterator = this.executeQuery(queryDSL);
            UnmodifiableIterator bulkUnitIdsIterator = Iterators.partition(unitIdsIterator, (int)VitamConfiguration.getBatchSize());
            bulkUnitIdsIterator.forEachRemaining(bulkUnitIds -> {
                GraphComputeResponse stats = this.computeGraph(MetadataCollections.UNIT, (Collection<String>)bulkUnitIds, true, false);
                response.increment(stats);
                LOGGER.info("Metadata graph computation in progress. Done " + response.getUnitCount() + " units / " + response.getGotCount() + " object groups");
            });
            LOGGER.info("Metadata graph computation completed");
            GraphComputeResponse graphComputeResponse = response;
            return graphComputeResponse;
        }
        finally {
            lock.set(false);
        }
    }

    private Iterator<String> executeQuery(JsonNode queryDSL) throws MetaDataException {
        SelectParserMultiple parser = new SelectParserMultiple();
        try {
            parser.parse(queryDSL);
        }
        catch (InvalidParseOperationException e) {
            throw new MetaDataException((Throwable)e);
        }
        SelectMultiQuery request = parser.getRequest();
        try {
            ObjectNode projection = JsonHandler.createObjectNode();
            ObjectNode fields = JsonHandler.createObjectNode();
            fields.put(ParserTokens.PROJECTIONARGS.ID.exactToken(), 1);
            projection.set(BuilderToken.PROJECTION.FIELDS.exactToken(), (JsonNode)fields);
            request.setProjection((JsonNode)projection);
        }
        catch (InvalidParseOperationException e) {
            throw new MetaDataException((Throwable)e);
        }
        ScrollSpliterator scrollSpliterator = new ScrollSpliterator(request, query -> {
            try {
                MetadataResult metadataResult = this.metaData.selectUnitsByQuery((JsonNode)query.getFinalSelect());
                return new RequestResponseOK(metadataResult.getQuery()).addAllResults(metadataResult.getResults()).addAllFacetResults(metadataResult.getFacetResults()).setHits(metadataResult.getHits());
            }
            catch (BadRequestException | InvalidParseOperationException | VitamDBException | MetaDataDocumentSizeException | MetaDataExecutionException | MetaDataNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }, VitamConfiguration.getElasticSearchScrollTimeoutInMilliseconds().intValue(), VitamConfiguration.getElasticSearchScrollLimit().intValue());
        return Iterators.transform((Iterator)new SpliteratorIterator((Spliterator)scrollSpliterator), doc -> doc.get(VitamFieldsHelper.id()).asText());
    }

    @Override
    public GraphComputeResponse computeGraph(MetadataCollections metadataCollections, Collection<String> documentsId, boolean computeObjectGroupGraph, boolean invalidateComputedInheritedRules) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Start Compute graph of (%s)", metadataCollections.name()));
        }
        this.tryInvalidateCache();
        HashSet<String> concernedGots = new HashSet<String>();
        GraphComputeResponse response = new GraphComputeResponse();
        if (CollectionUtils.isEmpty(documentsId)) {
            return response;
        }
        try {
            MongoCursor cursor = this.vitamRepositoryProvider.getVitamMongoRepository(metadataCollections.getVitamCollection()).findDocuments(Filters.in((String)"_id", documentsId), VitamConfiguration.getBatchSize()).projection(Projections.include((String[])new String[]{"_up", "_og", "_sp", "_sps", "_validComputedInheritedRules"})).iterator();
            ArrayList<Object> documents = new ArrayList<Document>();
            while (cursor.hasNext()) {
                response.increment(GraphComputeResponse.GraphComputeAction.valueOf((String)metadataCollections.name()), 1);
                Document doc = (Document)cursor.next();
                String got = doc.getString((Object)"_og");
                if (!Strings.isNullOrEmpty((String)got)) {
                    concernedGots.add(got);
                }
                documents.add(doc);
                if (cursor.hasNext() && documents.size() < VitamConfiguration.getBatchSize()) continue;
                this.computeGraph(metadataCollections, documents, invalidateComputedInheritedRules);
                documents = new ArrayList();
            }
            if (computeObjectGroupGraph && concernedGots.size() > 0) {
                GraphComputeResponse statsGots = this.computeGraph(MetadataCollections.OBJECTGROUP, concernedGots, false, invalidateComputedInheritedRules);
                response.increment(statsGots);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("End Compute graph of (%s)", metadataCollections.name()));
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("[Consistency ERROR] : Error while compute graph of (%s)", metadataCollections.name()), (Throwable)e);
            String msgCause = e.getCause() == null ? "" : e.getCause().getMessage();
            response.setErrorMessage(String.format("Compute graph error (%s) cause (%s)", e.getMessage(), msgCause));
        }
        return response;
    }

    private void tryInvalidateCache() {
        String operation = VitamThreadUtils.getVitamSession().getRequestId();
        if (!Objects.equals(operation, this.currentOperation)) {
            this.currentOperation = operation;
            LOGGER.info("[Graph compute] cache before invalidate : " + GraphComputeCache.getInstance().getCache().stats());
            this.getCache().invalidateAll();
        } else if (RandomUtils.nextInt((int)1, (int)20) % 2 == 0) {
            LOGGER.info("[Graph compute] cache : " + GraphComputeCache.getInstance().getCache().stats());
        }
    }

    private void bulkUpdateMongo(MetadataCollections metaDaCollection, List<WriteModel<Document>> collection) throws DatabaseException {
        this.vitamRepositoryProvider.getVitamMongoRepository(metaDaCollection.getVitamCollection()).update(collection);
    }

    private void bulkElasticsearch(MetadataCollections metaDaCollection, Set<String> collection) throws DatabaseException {
        if (collection.isEmpty()) {
            return;
        }
        FindIterable fit = this.vitamRepositoryProvider.getVitamMongoRepository(metaDaCollection.getVitamCollection()).findDocuments(collection, null);
        MongoCursor it = fit.iterator();
        ArrayList<Document> documents = new ArrayList<Document>();
        while (it.hasNext()) {
            documents.add((Document)it.next());
        }
        if (!documents.isEmpty()) {
            this.bulkElasticsearch(metaDaCollection, documents);
        }
    }

    private void bulkElasticsearch(MetadataCollections metaDaCollection, List<Document> collection) throws DatabaseException {
        this.vitamRepositoryProvider.getVitamESRepository(metaDaCollection.getVitamCollection(), this.indexManager.getElasticsearchIndexAliasResolver(metaDaCollection)).save(collection);
    }

    private void preLoadCache(List<Document> documents) throws MetaDataException {
        try {
            Set parentUnitIds;
            ImmutableCollection currentDocuments = documents;
            while (!(parentUnitIds = currentDocuments.stream().map(o -> o.getList((Object)"_up", String.class)).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).collect(Collectors.toSet())).isEmpty()) {
                currentDocuments = this.getCache().getAll(parentUnitIds).values();
            }
        }
        catch (ExecutionException e) {
            throw new MetaDataException((Throwable)e);
        }
    }

    private void computeGraph(MetadataCollections metadataCollections, List<Document> documents, boolean invalidateComputedInheritedRules) throws MetaDataException {
        block9: {
            this.preLoadCache(documents);
            try {
                Function func;
                switch (metadataCollections) {
                    case UNIT: {
                        func = document -> this.computeUnitGraph((Document)document, invalidateComputedInheritedRules);
                        break;
                    }
                    case OBJECTGROUP: {
                        func = this::computeObjectGroupGraph;
                        break;
                    }
                    default: {
                        throw new MetaDataException("Collection (" + metadataCollections + ") not supported");
                    }
                }
                Integer scopedTenant = VitamThreadUtils.getVitamSession().getTenantId();
                String scopedXRequestId = VitamThreadUtils.getVitamSession().getRequestId();
                CompletableFuture[] features = (CompletableFuture[])documents.stream().map(o -> CompletableFuture.supplyAsync(() -> {
                    VitamThreadUtils.getVitamSession().setTenantId(scopedTenant);
                    VitamThreadUtils.getVitamSession().setRequestId(scopedXRequestId);
                    return (WriteModel)func.apply(o);
                }, executor)).toArray(CompletableFuture[]::new);
                CompletionStage result = CompletableFuture.allOf(features).thenApply(v -> Stream.of(features).map(CompletableFuture::join).collect(Collectors.toList()));
                List updateOneModels = (List)((CompletableFuture)result).get();
                if (updateOneModels.isEmpty()) break block9;
                try {
                    this.bulkUpdateMongo(metadataCollections, updateOneModels);
                    this.bulkElasticsearch(metadataCollections, documents.stream().map(o -> o.getString((Object)"_id")).collect(Collectors.toSet()));
                }
                catch (DatabaseException e) {
                    throw new MetaDataException((Throwable)e);
                }
            }
            catch (VitamRuntimeException e) {
                throw new MetaDataException(e.getCause());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new MetaDataException((Throwable)e);
            }
        }
    }

    private UpdateOneModel<Document> computeUnitGraph(Document document, boolean invalidateComputedInheritedRules) throws VitamRuntimeException {
        ArrayList<GraphRelation> stackOrderedGraphRels = new ArrayList<GraphRelation>();
        List up = document.getList((Object)"_up", String.class);
        String unitId = document.getString((Object)"_id");
        String originatingAgency = document.getString((Object)"_sp");
        this.computeUnitGraphUsingDirectParents(stackOrderedGraphRels, unitId, up, 1);
        HashSet<String> graph = new HashSet<String>();
        HashSet<String> us = new HashSet<String>();
        HashSet<String> sps = new HashSet<String>();
        HashSetValuedHashMap uds = new HashSetValuedHashMap();
        if (StringUtils.isNotEmpty((String)originatingAgency)) {
            sps.add(originatingAgency);
        }
        for (GraphRelation ugr : stackOrderedGraphRels) {
            graph.add(GraphUtils.createGraphRelation((String)ugr.getUnit(), (String)ugr.getParent()));
            us.add(ugr.getParent());
            String parentOriginatingAgency = ugr.getParentOriginatingAgency();
            if (StringUtils.isNotEmpty((String)parentOriginatingAgency)) {
                sps.add(parentOriginatingAgency);
            }
            uds.put((Object)ugr.getDepth(), (Object)ugr.getParent());
        }
        HashMap<String, Collection> parentsDepths = new HashMap<String, Collection>();
        Map udsMap = uds.asMap();
        Integer min = 1;
        int max_minus_one = 0;
        for (Integer o : udsMap.keySet()) {
            Collection currentParents = (Collection)udsMap.get(o);
            if (currentParents.isEmpty()) continue;
            parentsDepths.put(String.valueOf(o), currentParents);
            max_minus_one = max_minus_one < o ? o : max_minus_one;
        }
        Integer max = max_minus_one + 1;
        Document update = new Document("_id", (Object)unitId).append("_us", us).append("_uds", parentsDepths).append("_sps", sps).append("_min", (Object)min).append("_max", (Object)max).append("_graph", graph).append("_glpd", (Object)LocalDateUtil.nowFormatted());
        Document data = new Document($_SET, (Object)update).append($_INC, (Object)new Document("_av", (Object)1));
        if (invalidateComputedInheritedRules && document.getBoolean((Object)"_validComputedInheritedRules", false)) {
            update.append("_validComputedInheritedRules", (Object)false);
            data.append($_UNSET, (Object)new Document("_computedInheritedRules", null));
        }
        return new UpdateOneModel(Filters.eq((String)"_id", (Object)unitId), (Bson)data, new UpdateOptions().upsert(false));
    }

    private UpdateOneModel<Document> computeObjectGroupGraph(Document document) throws VitamRuntimeException {
        HashSet<String> sps = new HashSet<String>();
        HashSet us = new HashSet();
        String gotId = document.getString((Object)"_id");
        List up = document.getList((Object)"_up", String.class);
        String originatingAgency = document.getString((Object)"_sp");
        if (StringUtils.isNotEmpty((String)originatingAgency)) {
            sps.add(originatingAgency);
        }
        List currentUpUnitIds = up;
        while (CollectionUtils.isNotEmpty((Collection)currentUpUnitIds)) {
            ImmutableCollection parentUnits;
            us.addAll(currentUpUnitIds);
            try {
                parentUnits = this.getCache().getAll((Iterable)currentUpUnitIds).values();
            }
            catch (ExecutionException e) {
                throw new VitamRuntimeException((Throwable)e);
            }
            parentUnits.stream().map(o -> o.getString((Object)"_sp")).filter(StringUtils::isNotEmpty).forEach(sps::add);
            currentUpUnitIds = parentUnits.stream().map(o -> o.getList((Object)"_up", String.class)).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).collect(Collectors.toList());
        }
        Document data = new Document($_SET, (Object)new Document("_sps", sps).append("_us", us).append("_glpd", (Object)LocalDateUtil.nowFormatted())).append($_INC, (Object)new Document("_av", (Object)1));
        return new UpdateOneModel(Filters.eq((String)"_id", (Object)gotId), (Bson)data, new UpdateOptions().upsert(false));
    }

    private void computeUnitGraphUsingDirectParents(List<GraphRelation> graphRels, String unitId, List<String> up, int currentDepth) throws VitamRuntimeException {
        ImmutableMap units;
        if (null == up || up.isEmpty()) {
            return;
        }
        try {
            units = this.getCache().getAll(up);
        }
        catch (ExecutionException e) {
            throw new VitamRuntimeException((Throwable)e);
        }
        int nextDepth = currentDepth + 1;
        for (Map.Entry unitParent : units.entrySet()) {
            Document parentUnit = (Document)unitParent.getValue();
            GraphRelation ugr = new GraphRelation(unitId, (String)unitParent.getKey(), parentUnit.getString((Object)"_sp"), currentDepth);
            if (graphRels.contains(ugr)) break;
            graphRels.add(ugr);
            this.computeUnitGraphUsingDirectParents(graphRels, (String)unitParent.getKey(), parentUnit.getList((Object)"_up", String.class), nextDepth);
        }
    }

    public void close() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Shutdown GraphBuilderService executor");
        }
        executor.shutdown();
        try {
            executor.awaitTermination(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            LOGGER.error("Error while shutting down GraphBuilderService executor", (Throwable)e);
            throw new VitamRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean isInProgress() {
        AtomicBoolean bool = this.lockers.get(VitamThreadUtils.getVitamSession().getTenantId());
        return bool.get();
    }

    private LoadingCache<String, Document> getCache() {
        return this.cache.getCache();
    }

    static {
        concurrencyLevel = Math.max(Runtime.getRuntime().availableProcessors(), 32);
        executor = ExecutorUtils.createScalableBatchExecutorService((int)concurrencyLevel);
    }
}

