/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.graph;

import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import fr.gouv.vitam.common.cache.AbstractVitamCache;
import fr.gouv.vitam.common.cache.VitamCache;
import fr.gouv.vitam.metadata.core.database.collections.MetadataCollections;
import java.util.HashMap;
import java.util.Map;
import org.bson.Document;

public class GraphComputeCache
extends AbstractVitamCache<String, Document> {
    private GraphComputeCache() {
    }

    protected Map<String, Document> loadByKeys(Iterable<? extends String> keys) {
        HashMap<String, Document> docs = new HashMap<String, Document>();
        try (MongoCursor it = MetadataCollections.UNIT.getCollection().find(Filters.in((String)"_id", keys)).projection(Projections.include((String[])new String[]{"_up", "_sp"})).iterator();){
            while (it.hasNext()) {
                Document doc = (Document)it.next();
                docs.put((String)doc.get((Object)"_id", String.class), doc);
            }
        }
        return docs;
    }

    protected Document loadByKey(String key) {
        return (Document)MetadataCollections.UNIT.getCollection().find(Filters.eq((String)"_id", (Object)key)).projection(Projections.include((String[])new String[]{"_up", "_sp"})).first();
    }

    public static VitamCache<String, Document> getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        private static final GraphComputeCache INSTANCE = new GraphComputeCache();

        private SingletonHolder() {
        }
    }
}

