/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.database.collections;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import fr.gouv.vitam.common.graph.GraphUtils;
import fr.gouv.vitam.metadata.core.database.collections.Unit;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class UnitGraphModel {
    private final String id;
    private final Set<String> up = new HashSet<String>();
    private final Set<String> us = new HashSet<String>();
    private final String originatingAgency;
    private final Set<String> originatingAgencies = new HashSet<String>();
    private final SetMultimap<Integer, String> uds = HashMultimap.create();
    private int maxDepth = 1;
    private final Set<String> graph = new HashSet<String>();

    public UnitGraphModel(String id, String originatingAgency) {
        this.id = id;
        this.originatingAgency = originatingAgency;
        if (originatingAgency != null) {
            this.originatingAgencies.add(originatingAgency);
        }
    }

    public UnitGraphModel(Unit unit) {
        this(unit.getId(), unit.getSp());
    }

    public void addParent(UnitGraphModel parent) {
        this.up.add(parent.id);
        this.us.add(parent.id);
        this.us.addAll(parent.us);
        this.originatingAgencies.addAll(parent.originatingAgencies);
        SetMultimap<Integer, String> parentUds = parent.uds;
        for (Map.Entry entry : parentUds.entries()) {
            this.uds.put((Object)((Integer)entry.getKey() + 1), (Object)((String)entry.getValue()));
        }
        this.uds.put((Object)1, (Object)parent.id);
        this.graph.add(GraphUtils.createGraphRelation((String)this.id, (String)parent.id));
        this.graph.addAll(parent.graph);
        this.maxDepth = this.uds.keys().stream().max(Comparator.naturalOrder()).orElse(0) + 1;
    }

    public String id() {
        return this.id;
    }

    public Set<String> parents() {
        return this.up;
    }

    public Set<String> ancestors() {
        return this.us;
    }

    public String originatingAgency() {
        return this.originatingAgency;
    }

    public Set<String> originatingAgencies() {
        return this.originatingAgencies;
    }

    public Map<String, Collection<String>> unitDepths() {
        return this.uds.asMap().entrySet().stream().collect(Collectors.toMap(i -> Integer.toString((Integer)i.getKey()), Map.Entry::getValue));
    }

    public int minDepth() {
        return 1;
    }

    public int maxDepth() {
        return this.maxDepth;
    }

    public Set<String> graph() {
        return this.graph;
    }
}

