/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.metadata.core.database.collections;

import com.fasterxml.jackson.databind.JsonNode;
import com.mongodb.client.MongoCollection;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.metadata.core.database.collections.MetadataCollections;
import fr.gouv.vitam.metadata.core.database.collections.MetadataDocument;
import fr.gouv.vitam.metadata.core.database.collections.UnitGraphModel;
import org.bson.Document;

public class Unit
extends MetadataDocument<Unit> {
    private static final long serialVersionUID = -4351321928647834270L;
    public static final String UNITDEPTHS = "_uds";
    public static final String UNITUPS = "_us";
    public static final String MINDEPTH = "_min";
    public static final String MAXDEPTH = "_max";
    public static final String MANAGEMENT = "_mgt";
    public static final String ELIMINATION = "_elimination";
    public static final String COMPUTED_INHERITED_RULES = "_computedInheritedRules";
    public static final String VALID_COMPUTED_INHERITED_RULES = "_validComputedInheritedRules";
    public static final String OPERATION_TRANSFERS = "_opts";
    public static final String UNIT_TYPE = "_unitType";
    public static final String GRAPH = "_graph";
    static final String HISTORY = "_history";
    static final String STORAGERULE = "_mgt.StorageRule";
    static final String APPRAISALRULE = "_mgt.AppraisalRule";
    static final String ACCESSRULE = "_mgt.AccessRule";
    static final String DISSEMINATIONRULE = "_mgt.DisseminationRule";
    static final String REUSERULE = "_mgt.ReuseRule";
    static final String CLASSIFICATIONRULE = "_mgt.ClassificationRule";
    static final String RULE = ".Rules.Rule";
    static final String END = ".Rules._end";
    static final String STORAGERULES = "_mgt.StorageRule.Rules.Rule";
    static final String STORAGEEND = "_mgt.StorageRule.Rules._end";
    static final String APPRAISALRULES = "_mgt.AppraisalRule.Rules.Rule";
    static final String APPRAISALEND = "_mgt.AppraisalRule.Rules._end";
    static final String ACCESSRULES = "_mgt.AccessRule.Rules.Rule";
    static final String ACCESSEND = "_mgt.AccessRule.Rules._end";
    static final String DISSEMINATIONRULES = "_mgt.DisseminationRule.Rules.Rule";
    static final String DISSEMINATIONEND = "_mgt.DisseminationRule.Rules._end";
    static final String REUSERULES = "_mgt.ReuseRule.Rules.Rule";
    static final String REUSEEND = "_mgt.ReuseRule.Rules._end";
    static final String CLASSIFICATIONRULES = "_mgt.ClassificationRule.Rules.Rule";
    static final String CLASSIFICATIONEND = "_mgt.ClassificationRule.Rules._end";

    public MetadataDocument<Unit> newInstance(JsonNode content) {
        return new Unit(content);
    }

    public Unit() {
    }

    public Unit(JsonNode content) {
        super(content);
    }

    public Unit(Document content) {
        super(content);
    }

    public Unit(String content) {
        super(content);
    }

    @Override
    protected MongoCollection<Unit> getCollection() {
        return MetadataCollections.UNIT.getCollection();
    }

    @Override
    protected MetadataCollections getMetadataCollections() {
        return MetadataCollections.UNIT;
    }

    public void mergeWith(UnitGraphModel unitGraphModel) {
        this.put("_up", unitGraphModel.parents());
        this.put(UNITUPS, unitGraphModel.ancestors());
        this.put(GRAPH, unitGraphModel.graph());
        this.put("_sps", unitGraphModel.originatingAgencies());
        this.put(UNITDEPTHS, unitGraphModel.unitDepths());
        this.put(MINDEPTH, unitGraphModel.minDepth());
        this.put(MAXDEPTH, unitGraphModel.maxDepth());
        this.put("_glpd", LocalDateUtil.nowFormatted());
    }
}

